<?php
/* * *******************************************************************************
 * The content of this file is subject to the Magsoft Customer Portal license.
 * ("License"); You may not use this file except in compliance with the License
 * All Rights Reserved.
 * ****************************************************************************** */
?>
    <!DOCTYPE html>
    <html lang="pt">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="author" content="">
        <title><?php if (isset($GLOBALS['portal_title'])) echo $GLOBALS['portal_title']; ?></title>
        <!-- Chrome, Firefox OS and Opera -->
        <meta name="theme-color" content="#0074D9">
        <!-- Windows Phone -->
        <meta name="msapplication-navbutton-color" content="#0074D9">
        <!-- iOS Safari -->
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-status-bar-style" content="#0074D9">
        <link rel="shortcut icon" href="themes/default/assets/img/favicon.ico" type="image/x-icon">
        <!-- Bootstrap Core CSS -->
        <link href="themes/default/assets/css/bootstrap.min.css" rel="stylesheet">
        <!-- MetisMenu CSS -->
        <link href="themes/default/assets/css/plugins/metisMenu/metisMenu.min.css" rel="stylesheet">
        <!-- Custom CSS -->
        <link href="themes/default/assets/css/sb-admin.css" rel="stylesheet">
        <link href="themes/default/assets/css/plugins/dataTables.bootstrap.css" rel="stylesheet">
        <!-- Custom Fonts -->
        <link href="themes/default/assets/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">
        <link href="themes/default/assets/css/chosen.min.css" rel="stylesheet" type="text/css">
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- jQuery Version 1.11.0 -->
        <script src="themes/default/assets/js/jquery-1.11.0.js"></script>
        <!-- Bootstrap Core JavaScript -->
        <script src="themes/default/assets/js/bootstrap.min.js"></script>
        <script src="themes/default/assets/js/chosen.jquery.min.js"></script>
        <!-- Metis Menu Plugin JavaScript -->
        <script src="themes/default/assets/js/plugins/metisMenu/metisMenu.min.js"></script>
        <script src="themes/default/assets/js/plugins/dataTables/jquery.dataTables.js"></script>
        <script src="themes/default/assets/js/plugins/dataTables/dataTables.bootstrap.js"></script>
        <!-- Custom Theme JavaScript -->
        <script src="themes/default/assets/js/sb-admin-2.js"></script>
        <!--<style>
            #page-wrapper{ min-height: 700px !important; }
        </style>-->
    </head>
<body class="login-area">
<div id="wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-4 col-md-offset-4">
                <div class="login-panel panel panel-default" id="loginpanel">
                    <div class="panel-body" style="border-bottom: 1px solid #eeeeee;">
                        <h3 class="panel-title text-center"
                            style="font-size:26px; font-weight: 400; padding:10px;"><?php echo Language::translate('customerportal'); ?></h3>
                    </div>
                    <div class="panel-body" style="padding:25px;">
                        <!--<div class="text-center">
	                    <img src="themes/default/assets/img/<?php echo $GLOBALS['portal_logo'] ?>" style="padding:0 0 30px 0; max-width:100%;">
                    </div>-->
                        <?php if (isset($loginerror)): ?>
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                <button type="button" class="close" data-dismiss="alert">
                                    <span aria-hidden="true">&times;</span><span class="sr-only"><?php echo Language::translate('LBL_CLOSE'); ?></span>
                                </button>
                                <i class="fa fa-exclamation"></i>
                                <?php echo Language::translate($loginerror); ?>
                            </div>
                        <?php endif; ?>
                        <?php if (isset($successmess)): ?>
                            <div class="alert alert-success alert-dismissible" role="alert">
                                <button type="button" class="close" data-dismiss="alert">
                                    <span aria-hidden="true">&times;</span><span class="sr-only"><?php echo Language::translate('LBL_CLOSE'); ?></span>
                                </button>
                                <i class="fa fa-check"></i>
                                <?php echo Language::translate($successmess); ?>
                            </div>
                        <?php endif; ?>
                        <form role="form" method="post">
                            <fieldset>
                                <div class="form-group">
                                    <input class="form-control"
                                           placeholder="<?php echo Language::translate('LBL_YOUR_EMAIL'); ?>"
                                           name="email" type="email" autofocus required>
                                </div>
                                <div class="form-group">
                                    <input class="form-control"
                                           placeholder="<?php echo Language::translate('LBL_PASSWORD'); ?>" name="pass"
                                           type="password" value="" required>
                                </div>
                                <div class="form-group">
                                    <select class="form-control" name="lang" required>
                                        <?php foreach ($GLOBALS['languages'] as $file => $lang) {
                                            echo '<option value="' . $file . '"';
                                            if ($file == $GLOBALS['default_language']) echo ' selected';
                                            echo '>' . $lang . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                                <hr>
                                <!-- Change this to a button or input when using this as a form -->
                                <button type="submit"
                                        class="btn btn-success btn-block"><?php echo Language::translate('Login'); ?></button>
                                <a onclick="$('#loginpanel').hide();$('#forgotpanel').show();"
                                   class="btn btn-warning btn-block"><?php echo Language::translate('Esqueceu a senha?'); ?></a>
                            </fieldset>
                        </form>
                    </div>
                </div>
                <div class="login-panel panel panel-default" id="forgotpanel">
                    <div class="panel-body" style="border-bottom: 1px solid #eeeeee;">
                        <h3 class="panel-title text-center"
                            style="font-size:26px; font-weight: 400; padding:10px;"><?php echo Language::translate('Enviar nova senha'); ?></h3>
                    </div>
                    <div class="panel-body" style="padding:25px;">
                        <form role="form" method="post">
                            <fieldset>
                                <div class="form-group">
                                    <input class="form-control"
                                           placeholder="<?php echo Language::translate('Email'); ?>" name="email"
                                           type="email" autofocus required>
                                    <input name="forgot" type="hidden" value="1">
                                </div>
                                <!-- Change this to a button or input when using this as a form -->
                                <button type="submit"
                                        class="btn btn-success btn-block"><?php echo Language::translate('Enviar nova senha'); ?></button>
                                <a onclick="$('#forgotpanel').hide();$('#loginpanel').show();"
                                   class="btn btn-warning btn-block"><?php echo Language::translate('Voltar ao login'); ?></a>
                            </fieldset>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script> $(function () {
            $('#forgotpanel').hide();
        }) </script>
<?php
require_once 'themes/default/footer.php';
?>