<?php
/* * *******************************************************************************
 * The content of this file is subject to the Magsoft Customer Portal license.
 * ("License"); You may not use this file except in compliance with the License
 * All Rights Reserved.
 * ****************************************************************************** */
?>
<div id="page-wrapper">
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header"><?php echo Language::translate($module); ?> </h1>
        </div>
        <!-- /.col-lg-12 -->
    </div>
    <?php
    if (isset($data['plugin_data']['views']['header'])) {
        foreach ($data['plugin_data']['views']['header'] as $pluginname => $viewname) {
            Template::displayPlugin($pluginname, $data, $viewname);
        }
    }
    ?>
    <div class="row">
        <div class="col-lg-12">
            <?php if (isset($data) && count($data) > 0) { ?>
                <?php foreach ($data as $table): ?>
                    <?php if (isset($table['recordlist']) && is_array($table['recordlist']) && count($table['recordlist']) > 0) { ?>
                        <?php //if(isset($table['recordlist']) && count($table['recordlist'])>0 && $table['recordlist']!=""){ ?>
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <?php echo Language::translate($table['tablename']); ?>
                            </div>
                            <!-- /.panel-heading -->
                            <div class="panel-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered table-hover dataTables"
                                           id="dataTables-example">
                                        <thead>
                                        <tr>
                                            <?php foreach ($table['tableheader'] as $hf) echo "<th>" . Language::translate($hf['fielddata']) . "</th>"; ?>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        foreach ($table['recordlist'] as $record) {

                                            echo "<tr>";
                                            foreach ($record as $record_fields) echo "<td>" . Language::translate($record_fields['fielddata']) . "</td>";
                                            echo "</tr>";

                                        }

                                        ?>
                                        </tbody>
                                    </table>
                                    <div class="panel-footer-table">
                                        <div class="row">
                                            <div id="footer-left" class="col-sm-6 pull-left">
                                            </div>
                                            <div id="footer-right" class="col-sm-6 pull-right">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                        <!-- /.panel -->
                    <?php } ?>
                <?php endforeach; ?>
            <?php } else { ?>
                <h2><?php echo Language::translate("No " . $module . " records Found!"); ?></h2>
                <br>
            <?php } ?>
        </div>
        <!-- /.col-lg-12 -->
    </div>
    <!-- /.row -->
    <?php
    if (isset($data['plugin_data']['views']['footer'])) {
        foreach ($data['plugin_data']['views']['footer'] as $pluginname => $viewname) {
            Template::displayPlugin($pluginname, $data, $viewname);
        }
    }
    ?>
</div>
<!-- /#page-wrapper -->
<script>
    $(document).ready(function () {
        $('#dataTables-example').dataTable({
            //"iDisplayLength": 50,
            //"oSearch": {"sSearch": "Aberto"}
            //"orderFixed": [ 4, 'asc' ]
            "language": {
                "lengthMenu": "_MENU_",
                "search": "",
                "searchPlaceholder": "Pesquisar ...",
                "zeroRecords": "Sem resultados encontrados",
                "info": "Página _PAGE_ de _PAGES_",
                "infoEmpty": "Sem resultados",
                "infoFiltered": "(total: _MAX_)",
                "paginate": {
                    "first": "Primeira",
                    "last": "Última",
                    "next": "Seguinte",
                    "previous": "Anterior"
                }
            }
        });
        $("#dataTables-example_info").detach().appendTo('#footer-left');
        $("#dataTables-example_paginate").detach().appendTo('#footer-right');
        $("tfoot").detach().appendTo('#dataTables-example_filter');
    });
</script>
<!--<script>
    $(document).ready(function () {
        $('#dataTables-example').dataTable();
        $("#dataTables-example_info").detach().appendTo('#footer-left');
        $("#dataTables-example_paginate").detach().appendTo('#footer-right');
    });
</script>-->