<?php
/* ********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 * ****************************************************************************** */
require_once('modules/com_magsoft_workflow/VTEntityCache.inc');
require_once('modules/com_magsoft_workflow/VTWorkflowUtils.php');

class RelatedRecordUpdateTask extends VTTask
{

    public $executeImmediately = true;

    public function getFieldNames()
    {
        return array('field_value_mapping');
    }

    public function getRelatedModules($module)
    {
        global $adb;

        $relatedModules = array();
        $currentModuleModel = Magsoft_Module_Model::getInstance($module);
        $uitypes = array();
        // Get related modules
        switch ($module) {
            case "Accounts":
                $uitypes = array('51', '73', '68');
                break;
            case "Contacts":
                $uitypes = array('57', '68');
                break;
            case "Campaigns":
                $uitypes = array('58');
                break;
            case "Products":
                $uitypes = array('59');
                break;
            case "Vendors":
                $uitypes = array('75', '81');
                break;
            case "Potentials":
                $uitypes = array('76');
                break;
            case "Quotes":
                $uitypes = array('78');
                break;
            case "SalesOrder":
                $uitypes = array('80');
                break;
        }
        $rsRelatedFields = $adb->pquery("SELECT magsoft_tab.tabid,magsoft_tab.`name` as relationmodulename,columnname,fieldname
                    FROM `magsoft_field`
                    INNER JOIN magsoft_tab ON magsoft_field.tabid=magsoft_tab.tabid
                    WHERE magsoft_field.presence <> 1 AND uitype IN (" . generateQuestionMarks($uitypes) . ");", array($uitypes));


        if ($adb->num_rows($rsRelatedFields) > 0) {
            while ($rowRelatedField = $adb->fetch_array($rsRelatedFields)) {
                $referenceModule = $rowRelatedField['relationmodulename'];
                $relatedModuleModel = Magsoft_Module_Model::getInstance($referenceModule);
                $referenceFieldName = $rowRelatedField['fieldname'];
                if (!in_array($referenceModule, array_keys($relatedModules)) && $referenceModule != '' && $referenceModule != 'Users' && $referenceModule != 'Calendar') {
                    $relatedModules[$referenceModule]['ModuleModel'] = $relatedModuleModel;
                    $relatedModules[$referenceModule]['ReferenceField'] = $referenceFieldName . "::" . 'CHILD';
                }
            }
        }

        // get related module by uitype = 10
        $rsRelatedFields = $adb->pquery("SELECT magsoft_fieldmodulerel.module as relationmodulename,columnname,fieldname FROM magsoft_fieldmodulerel
INNER JOIN magsoft_field ON magsoft_fieldmodulerel.fieldid=magsoft_field.fieldid
WHERE magsoft_field.presence <> 1 AND uitype = 10 AND relmodule = ?", array($module));
        if ($adb->num_rows($rsRelatedFields) > 0) {
            while ($rowRelatedField = $adb->fetch_array($rsRelatedFields)) {
                $referenceModule = $rowRelatedField['relationmodulename'];
                $relatedModuleModel = Magsoft_Module_Model::getInstance($referenceModule);
                $referenceFieldName = $rowRelatedField['fieldname'];
                if (!in_array($referenceModule, array_keys($relatedModules)) && $referenceModule != '' && $referenceModule != 'Users' && $referenceModule != 'Calendar') {
                    $relatedModules[$referenceModule]['ModuleModel'] = $relatedModuleModel;
                    $relatedModules[$referenceModule]['ReferenceField'] = $referenceFieldName . "::" . 'CHILD';
                }
            }
        }

        // Get parent module
        $referenceFields = $currentModuleModel->getFieldsByType('reference');
        foreach ($referenceFields as $fieldModel) {
            $reference_list = $fieldModel->getReferenceList();
            $referenceFieldName = $fieldModel->getFieldName();
            foreach ($reference_list as $referenceModule) {
                if (!in_array($referenceModule, array_keys($relatedModules)) && $referenceModule != '' && $referenceModule != 'Users' && $referenceModule != 'Calendar') {
                    $relatedModuleModel = Magsoft_Module_Model::getInstance($referenceModule);
                    $relatedModules[$referenceModule]['ModuleModel'] = $relatedModuleModel;
                    $relatedModules[$referenceModule]['ReferenceField'] = $referenceFieldName . "::" . 'PARENT';
                }
            }
        }

        return $relatedModules;
    }

    public function doTask($entity)
    {
        global $adb, $current_user, $default_charset;
        $util = new VTWorkflowUtils();
        $current_user = $util->loggedInUser();

        $moduleName = $entity->getModuleName();
        $entityId = $entity->getId();
        $recordId = vtws_getIdComponents($entityId);
        $recordId = $recordId[1];

        $fieldValueMapping = array();
        if (!empty($this->field_value_mapping)) {
            $fieldValueMapping = Zend_Json::decode($this->field_value_mapping);
        }

        if (!empty($fieldValueMapping) && count($fieldValueMapping) > 0) {
            $reformatMapping = array();
            foreach ($fieldValueMapping as $fieldInfo) {
                $fieldName = $fieldInfo['fieldname'];
                $relatedFieldName = $fieldInfo['related_fieldname'];
                list($relModule, $referenceField, $relType, $relFieldName) = explode('::', $relatedFieldName);
                $reformatMapping[$relType][$relModule][$referenceField][$relFieldName] = $fieldName;
            }

            require_once('data/CRMEntity.php');
            $focus = CRMEntity::getInstance($moduleName);
            $focus->id = $recordId;
            $focus->retrieve_entity_info($recordId, $moduleName);
            $arrRelFocus = array();

            // Update parent record
            foreach ($reformatMapping['PARENT'] as $relModule => $relMappingInfo) {
                foreach ($relMappingInfo as $referenceField => $mapping) {
                    $relRecordId = $focus->column_fields[$referenceField];
                    $relRecordEntityType = getSalesEntityType($relRecordId);
                    if ($relRecordId && $relRecordEntityType == $relModule) {
                        if (!$arrRelFocus[$relModule][$relRecordId]) {
                            $relFocus = CRMEntity::getInstance($relModule);
                            $relFocus->id = $relRecordId;
                            $relFocus->mode = 'edit';
                            $relFocus->retrieve_entity_info($relRecordId, $relModule);
                            $relFocus->clearSingletonSaveFields();

                            /// Fix issue system insert wrong value when related record have special character #27461
                            $relFields = $relFocus->column_fields;
                            $relRecordModel = Magsoft_Record_Model::getInstanceById($relRecordId, $relModule);
                            foreach ($relFields as $rFieldName => $FieldValue) {
                                $FieldValue = $relRecordModel->get($rFieldName);
                                if (is_array($FieldValue)) {
                                    $relFocus->column_fields[$rFieldName] = $FieldValue;
                                } else if ($FieldValue !== null) {
                                    $relFocus->column_fields[$rFieldName] = decode_html($FieldValue);
                                }
                            }
                            $arrRelFocus[$relModule][$relRecordId] = $relFocus;
                        } else {
                            $relFocus = $arrRelFocus[$relModule][$relRecordId];
                        }
                        foreach ($mapping as $relFieldName => $fieldName) {
                            $relFocus->column_fields[$relFieldName] = $focus->column_fields[$fieldName];
                        }
                    }
                }
            }

            // Update related records
            foreach ($reformatMapping['CHILD'] as $relModule => $relMappingInfo) {
                $parentRecordModel = Magsoft_Record_Model::getInstanceById($recordId);
                $relationListView = Magsoft_RelationListView_Model::getInstance($parentRecordModel, $relModule);
                $relatedQuery = $relationListView->getRelationQuery();
                $rsData = $adb->pquery($relatedQuery);
                if ($adb->num_rows($rsData) > 0) {
                    while ($rowData = $adb->fetch_array($rsData)) {
                        $relRecordId = $rowData['crmid'];
                        $relRecordEntityType = getSalesEntityType($relRecordId);
                        if ($relRecordId && $relRecordEntityType == $relModule) {
                            if (!$arrRelFocus[$relModule][$relRecordId]) {
                                $relFocus = CRMEntity::getInstance($relModule);
                                $relFocus->id = $relRecordId;
                                $relFocus->mode = 'edit';
                                $relFocus->retrieve_entity_info($relRecordId, $relModule);
                                $relFocus->clearSingletonSaveFields();

                                /// Fix issue system insert wrong value when related record have special character #27461
                                $relFields = $relFocus->column_fields;
                                $relRecordModel = Magsoft_Record_Model::getInstanceById($relRecordId, $relModule);
                                foreach ($relFields as $rFieldName => $FieldValue) {
                                    $FieldValue = $relRecordModel->get($rFieldName);
                                    if (is_array($FieldValue)) {
                                        $relFocus->column_fields[$rFieldName] = $FieldValue;
                                    } else if ($FieldValue !== null) {
                                        $relFocus->column_fields[$rFieldName] = decode_html($FieldValue);
                                    }
                                }
                                $arrRelFocus[$relModule][$relRecordId] = $relFocus;
                            } else {
                                $relFocus = $arrRelFocus[$relModule][$relRecordId];
                            }
                            foreach ($relMappingInfo as $referenceField => $mapping) {
                                foreach ($mapping as $relFieldName => $fieldName) {
                                    $relFocus->column_fields[$relFieldName] = $focus->column_fields[$fieldName];
                                }
                            }
                        }
                    }
                }
            }
        }

        foreach ($arrRelFocus as $relModule => $relRecordFocus) {
            foreach ($relRecordFocus as $record => $relFocus) {
                $_REQUEST['file'] = '';
                $_REQUEST['ajxaction'] = '';

                $actionName = $_REQUEST['action'];
                $_REQUEST['action'] = '';

                // For workflows update field tasks is deleted all the lineitems.
                $relFocus->isLineItemUpdate = false;

                $relFocus->saveentity($relModule);

                // Reverting back the action name as there can be some dependencies on this.
                $_REQUEST['action'] = $actionName;
            }
        }
        $util->revertUser();
    }
}
