<?php
/* ********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 * ****************************************************************************** */

include_once 'vtlib/Magsoft/Module.php';

class RelatedRecordUpdate_Uninstall_View extends Settings_Magsoft_Index_View
{

    function process(Magsoft_Request $request)
    {
        global $adb;
        echo '<div class="container-fluid">
                <div class="widget_header row-fluid">
                    <h3>Related Record Update</h3>
                </div>
                <hr>';
        // Uninstall module magsoft_relatedrecordupdate_settings
        $module = Magsoft_Module::getInstance('RelatedRecordUpdate');
        if ($module) $module->delete();

        // drop tables
        $sql = "DROP TABLE `magsoft_relatedrecordupdate_settings`;";
        $result = $adb->pquery($sql, array());

        echo "&nbsp;&nbsp;- Delete Related Record Update tables";
        if ($result) echo " - DONE"; else echo " - <b>ERROR</b>";
        echo '<br>';

        $res_template = $this->delete_folder('layouts/vlayout/modules/RelatedRecordUpdate');
        echo "&nbsp;&nbsp;- Delete Related Record Update template folder";
        if ($res_template) echo " - DONE"; else echo " - <b>ERROR</b>";
        echo '<br>';

        $res_module = $this->delete_folder('modules/RelatedRecordUpdate');
        echo "&nbsp;&nbsp;- Delete Related Record Update module folder";
        if ($res_module) echo " - DONE"; else echo " - <b>ERROR</b>";
        echo '<br>';
        // Remove module from other settings
        $adb->pquery("DELETE FROM magsoft_settings_field WHERE `name` = ?", array('Related Record Update'));
        echo "Module was Uninstalled.";
        echo '</div>';
    }

    function delete_folder($tmp_path)
    {
        if (!is_writeable($tmp_path) && is_dir($tmp_path) && isFileAccessible($tmp_path)) {
            chmod($tmp_path, 0777);
        }
        $handle = opendir($tmp_path);
        while ($tmp = readdir($handle)) {
            if ($tmp != '..' && $tmp != '.' && $tmp != '') {
                if (is_writeable($tmp_path . DS . $tmp) && is_file($tmp_path . DS . $tmp) && isFileAccessible($tmp_path)) {
                    unlink($tmp_path . DS . $tmp);
                } elseif (!is_writeable($tmp_path . DS . $tmp) && is_file($tmp_path . DS . $tmp) && isFileAccessible($tmp_path)) {
                    chmod($tmp_path . DS . $tmp, 0666);
                    unlink($tmp_path . DS . $tmp);
                }

                if (is_writeable($tmp_path . DS . $tmp) && is_dir($tmp_path . DS . $tmp) && isFileAccessible($tmp_path)) {
                    $this->delete_folder($tmp_path . DS . $tmp);
                } elseif (!is_writeable($tmp_path . DS . $tmp) && is_dir($tmp_path . DS . $tmp) && isFileAccessible($tmp_path)) {
                    chmod($tmp_path . DS . $tmp, 0777);
                    $this->delete_folder($tmp_path . DS . $tmp);
                }
            }
        }
        closedir($handle);
        rmdir($tmp_path);
        if (!is_dir($tmp_path)) {
            return true;
        } else {
            return false;
        }
    }
}