<?php
/* ********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 * ****************************************************************************** */
ini_set('display_errors', '0');

class RelatedRecordUpdate_Settings_View extends Settings_Magsoft_Index_View
{
    function __construct()
    {
        parent::__construct();
    }

    public function process(Magsoft_Request $request)
    {
        $this->renderSettingsUI($request);
    }

    function renderSettingsUI(Magsoft_Request $request)
    {
        $adb = PearDatabase::getInstance();
        $module = $request->getModule();
        $viewer = $this->getViewer($request);
        $rs = $adb->pquery("SELECT `enable` FROM `magsoft_relatedrecordupdate_settings`;", array());
        $enable = $adb->query_result($rs, 0, 'enable');
        $viewer->assign('ENABLE', $enable);
        echo $viewer->view('Settings.tpl', $module, true);
    }

    /**
     * Function to get the list of Script models to be included
     * @param Magsoft_Request $request
     * @return <Array> - List of Magsoft_JsScript_Model instances
     */
    function getHeaderScripts(Magsoft_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.$moduleName.resources.Settings",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}