<?php
/* ********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 * ****************************************************************************** */
Magsoft_Loader::includeOnce('~~modules/com_magsoft_workflow/include.inc');
Magsoft_Loader::includeOnce('~~modules/com_magsoft_workflow/tasks/VTEntityMethodTask.inc');
Magsoft_Loader::includeOnce('~~modules/com_magsoft_workflow/VTEntityMethodManager.inc');

class RelatedRecordUpdate_ActionAjax_Action extends Magsoft_Action_Controller
{

    function checkPermission(Magsoft_Request $request)
    {
        return;
    }

    function __construct()
    {
        parent::__construct();
        $this->exposeMethod('enableModule');
    }

    function process(Magsoft_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
    }

    function enableModule(Magsoft_Request $request)
    {
        global $adb;
        $value = $request->get('value');
        $adb->pquery("UPDATE `magsoft_relatedrecordupdate_settings` SET `enable`=?", array($value));
        if ($value == 1) {
            // Add workflow task
            $taskType = array("name" => "RelatedRecordUpdateTask", "label" => "Related Record Update Task", "classname" => "RelatedRecordUpdateTask", "classpath" => "modules/RelatedRecordUpdate/workflow/RelatedRecordUpdateTask.inc", "templatepath" => "modules/RelatedRecordUpdate/taskforms/RelatedRecordUpdateTask.tpl", "modules" => array('include' => array(), 'exclude' => array()), "sourcemodule" => 'RelatedRecordUpdate');
            VTTaskType::registerTaskType($taskType);
        } else {
            // Remove workflow task
            $adb->pquery('DELETE FROM com_magsoft_workflow_tasktypes WHERE tasktypename=? AND sourcemodule=? AND classname=?', array('RelatedRecordUpdateTask', 'RelatedRecordUpdate', 'RelatedRecordUpdateTask'));
        }
        $response = new Magsoft_Response();
        $response->setEmitType(Magsoft_Response::$EMIT_JSON);
        $response->setResult(array('result' => 'success'));
        $response->emit();
    }
}