<?php
/* ********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 * ****************************************************************************** */

require_once 'data/CRMEntity.php';
require_once 'data/Tracker.php';
require_once 'vtlib/Magsoft/Module.php';
require_once 'modules/com_magsoft_workflow/include.inc';

class RelatedRecordUpdate extends CRMEntity
{
    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
     */
    function vtlib_handler($modulename, $event_type)
    {
        global $adb;
        if ($event_type == 'module.postinstall') {
            self::checkEnable();
            self::addSettings();
            self::installWorkflow();
        } else if ($event_type == 'module.disabled') {
            // TODO Handle actions when this module is disabled.
            self::removeSettings();
            self::removeWorkflows();
        } else if ($event_type == 'module.enabled') {
            // TODO Handle actions when this module is enabled.
            self::addSettings();
            self::installWorkflow();
        } else if ($event_type == 'module.preuninstall') {
            // TODO Handle actions when this module is about to be deleted.
            self::removeSettings();
            self::removeWorkflows();
        } else if ($event_type == 'module.preupdate') {
            // TODO Handle actions before this module is updated.
        } else if ($event_type == 'module.postupdate') {
            self::removeSettings();
            self::removeWorkflows();
            self::checkEnable();
            self::addSettings();
            self::installWorkflow();
        }
    }

    static function checkEnable()
    {
        global $adb;
        $rs = $adb->pquery("SELECT `enable` FROM `magsoft_relatedrecordupdate_settings`;", array());
        if ($adb->num_rows($rs) == 0) {
            $adb->pquery("INSERT INTO `magsoft_relatedrecordupdate_settings` (`enable`) VALUES ('0');", array());
        }
    }


    static function addSettings()
    {
        global $adb;

        $max_id = $adb->getUniqueID('magsoft_settings_field');
        $adb->pquery("INSERT INTO `magsoft_settings_field` (`fieldid`, `blockid`, `name`, `description`, `linkto`, `sequence`) VALUES (?, ?, ?, ?, ?, ?)", array($max_id, '4', 'Related Record Update', 'Related Record Update', 'index.php?module=RelatedRecordUpdate&parent=Settings&view=Settings', $max_id));
    }

    static function removeSettings()
    {
        global $adb;
        $adb->pquery("DELETE FROM magsoft_settings_field WHERE `name` = ?", array('Related Record Update'));
    }

    static function installWorkflow()
    {
        global $adb;
        $name = 'RelatedRecordUpdateTask';
        $dest1 = "modules/com_magsoft_workflow/tasks/" . $name . ".inc";
        $source1 = "modules/RelatedRecordUpdate/workflow/" . $name . ".inc";

        if (file_exists($dest1)) {
            $file_exist1 = true;
        } else {
            if (copy($source1, $dest1)) {
                $file_exist1 = true;
            }
        }

        $dest2 = "layouts/vlayout/modules/Settings/Workflows/Tasks/" . $name . ".tpl";
        $source2 = "layouts/vlayout/modules/RelatedRecordUpdate/taskforms/" . $name . ".tpl";

        if (file_exists($dest2)) {
            $file_exist2 = true;
        } else {
            if (copy($source2, $dest2)) {
                $file_exist2 = true;
            }
        }

        if ($file_exist1 && $file_exist2) {
            $sql1 = "SELECT * FROM com_magsoft_workflow_tasktypes WHERE tasktypename = ?";
            $result1 = $adb->pquery($sql1, array($name));

            if ($adb->num_rows($result1) == 0) {
                // Add workflow task
                $taskType = array("name" => "RelatedRecordUpdateTask", "label" => "Related Record Update Task", "classname" => "RelatedRecordUpdateTask", "classpath" => "modules/RelatedRecordUpdate/workflow/RelatedRecordUpdateTask.inc", "templatepath" => "modules/RelatedRecordUpdate/taskforms/RelatedRecordUpdateTask.tpl", "modules" => array('include' => array(), 'exclude' => array()), "sourcemodule" => 'RelatedRecordUpdate');
                VTTaskType::registerTaskType($taskType);
            }
        }
    }

    static function removeWorkflows()
    {
        global $adb;
        $sql1 = "DELETE FROM com_magsoft_workflow_tasktypes WHERE sourcemodule = ?";
        $adb->pquery($sql1, array('RelatedRecordUpdate'));

        $sql2 = "DELETE FROM com_magsoft_workflowtasks WHERE task LIKE ?";
        $adb->pquery($sql2, array('%:"RelatedRecordUpdateTask":%'));

        @shell_exec('rm -f modules/com_magsoft_workflow/tasks/RelatedRecordUpdateTask.inc');
        @shell_exec('rm -f layouts/vlayout/modules/Settings/Workflows/Tasks/RelatedRecordUpdateTask.tpl');
    }
}
