<?php
/*+**********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/
include_once dirname(__FILE__) . '/../Alert.php';

/** Pending Ticket Alert */
class Mobile_WS_AlertModel_PendingTicketsOfMine extends Mobile_WS_AlertModel
{
    function __construct()
    {
        parent::__construct();
        $this->name = 'Pending Ticket Alert';
        $this->moduleName = 'HelpDesk';
        $this->refreshRate = 1 * (24 * 60 * 60); // 1 day
        $this->description = 'Alert sent when ticket assigned is not yet closed';
    }

    function query()
    {
        $sql = "SELECT crmid FROM magsoft_troubletickets INNER JOIN 
				magsoft_crmentity ON magsoft_crmentity.crmid=magsoft_troubletickets.ticketid 
				WHERE magsoft_crmentity.deleted=0 AND magsoft_crmentity.smownerid=? AND 
				magsoft_troubletickets.status <> 'Closed'";
        return $sql;
    }

    function queryParameters()
    {
        return array($this->getUser()->id);
    }
}