/**
 * @license Copyright (c) 2003-2019, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see https://ckeditor.com/legal/ckeditor-oss-license
 */

CKEDITOR.editorConfig = function (config) {
    // Define changes to default configuration here. For example:
    // config.language = 'fr';
    // config.uiColor = '#AADC6E';

    //config.filebrowserBrowseUrl = 'libraries/finder/finder-magsoft.html';
    config.filebrowserBrowseUrl = 'libraries/finder/finder-magsoft.html';
    //config.filebrowserUploadUrl = 'libraries/finder/php/upload.php?type=file';
    config.imageUploadUrl = 'libraries/finder/php/upload.php?type=image';

    config.enterMode = CKEDITOR.ENTER_BR;
    config.shiftEnterMode = CKEDITOR.ENTER_P;

    config.skin = 'bootstrapck';
    //config.removePlugins = 'templates,Save,NewPage,autosave,flash,forms,oembed,iframe,gg,bbcode';
    config.removePlugins = 'preview,print,footnotes,flash,forms,iframe,templates,image';
    //config.addPlugins = 'resize';
    //config.extraPlugins = 'uploadimage,image2';

    config.resize_enabled = true;
    config.toolbarCanCollapse = false;
    config.allowedContent = true;

    config.toolbar = [
        {name: 'document', items: ['Source']},
        {name: 'clipboard', groups: ['clipboard', 'undo'], items: ['Undo', 'Redo']},
        {name: 'justify', items: ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']},
        //{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ], items: [ 'Blockquote', 'CreateDiv', '-', 'BidiLtr', 'BidiRtl'] },
        {name: 'insert', items: ['Image', 'Table', 'HorizontalRule', 'PageBreak', 'Smiley']},
        {name: 'links', items: ['Link', 'Unlink']},
        {name: 'styles', items: ['FontSize', 'Styles', 'Format', 'Font']},
        {name: 'basicstyles', groups: ['basicstyles', 'cleanup'], items: ['Bold', 'Italic', 'Underline']},
        {name: 'colors', items: ['TextColor', 'BGColor']},
        //{ name: 'tools', items: [ 'Maximize', 'ShowBlocks' ] },
        //{ name: 'others', items: [ '-' ] }
    ];

    config.font_names =
        'Arial/Arial, Helvetica, sans-serif;' +
        'Comic Sans MS;' +
        //'Comic Sans MS/Comic Sans MS, cursive;' +
        'Courier New/Courier New, Courier, monospace;' +
        'DejaVu Sans;' +
        'DejaVu Sans Condensed;' +
        'DejaVu Sans Mono;' +
        'DejaVu Serif;' +
        'DejaVu Serif Condensed;' +
        'Georgia;' +
        'Lucida Sans Unicode;' +
        //'Lucida Sans Unicode/Lucida Sans Unicode, Lucida Grande, sans-serif;' +
        'Tahoma;' +
        //'Tahoma/Tahoma, Geneva, sans-serif;' +
        'Times New Roman/Times New Roman, Times, serif;' +
        'Trebuchet MS;' +
        // 'Trebuchet MS/Trebuchet MS, Helvetica, sans-serif;' +
        'Verdana';
};
