{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    <html lang="en">
    <head>
        <title>Magsoft CRM Setup</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
        <link rel="stylesheet" href="libraries/bootstrap/css/bootstrap.css" type="text/css" media="screen"/>
        <link rel="stylesheet" href="layouts/vlayout/modules/Install/resources/css/style.css" type="text/css" media="screen"/>
        <link rel="stylesheet" href="libraries/bootstrap/css/bootstrap-responsive.css" type="text/css" media="screen">
        <style type="text/css">
            {literal}
            body {
                font-family: "Lucida Grande", Tahoma, Verdana;
                background: #EEEEEE;
                color: #555;
                font-size: 13px;
                min-height: 98%;
            }

            p {
                font-family: "Lucida Grande", Tahoma, Verdana;
                font-size: 14px;
            }

            .offset2 {
                position: relative;
                left: 9% !important;
            }

            div {
                box-sizing: border-box; /* Opera/IE 8+ */
            }

            hr {
                border: 1px solid #ddd;
                border-bottom: 0;
                border-right: 0;
                border-left: 0;
                margin-top: 16px;
            }

            .page-container {
                width: 70%;
                margin: 10px auto;
                min-width: 960px;
            }

            .main-container {
                background: #fff;
                border: 1px solid #ddd;
                border-radius: 3px;
                min-height: 375px;
            }

            .logo {
                padding: 15px 0;
            }

            .inner-container {
                padding: 15px 2%;
            }

            .group-container {
                background-color: #FFFFFF !important;
                border: 1px solid #ddd;
                border-radius: 3px;
                margin-bottom: 25px;
                padding: 15px;
                position: relative;
                height: 190px !important;
            }

            .selectedContainer {
                background: #FFFFFF;
            }

            .unSelectedContainer {
                background: #FFFFFF;
            }

            .group-container > .row-fluid > .span9 {
                min-height: 142px;
            }

            .row-fluid .group-container {
                min-height: 185px !important;
            }

            .group-heading input {
                display: inline-block;
                float: left;
            }

            .group-heading h4 {
                color: #2c69a7;
                display: inline-block;
                font-size: 16px;
                vertical-align: bottom;
                margin-left: 10px \9;
                margin-top: 8px \9;
            }

            .group-desc {
                padding-bottom: 9px;
                min-height: 130px;
            }

            .btn-primary {
                background-color: #006dcc;
                border-color: #006dcc;
                text-shadow: none;
                box-shadow: none;
                font-size: 13px;
                border-radius: 2px;
            }

            .btn-primary:hover {
                background-color: #0044cc;
                border-color: #0044cc;
                text-shadow: none;
                box-shadow: none;
            }

            .module_list {
                background: #146bae;
                border-radius: 0 0 2px 2px;
                left: 0;
                bottom: 0;
                position: absolute;
                width: 100%;
                color: #fff;
                font-weight: bold;
                padding: 3px 10px;
                z-index: 605;
                cursor: pointer;
                text-shadow: none !important;
            }

            .module_list a {
                cursor: pointer;
                text-decoration: none;
                color: #fff;
            }

            .reveal_modules {
                position: absolute;
                height: 0;
                width: 0;
                z-index: 600;
                background: #333;
                opacity: 0;
                top: 100%;
                left: 100%;
                bottom: 0;
                right: 0;
                color: #fff;
                visibility: hidden;
                border-radius: 2px;
            }

            /** temporary**/
            .reveal_modules > div {
                padding: 15px 20px;
            }

            /****/
            label {
                margin-bottom: 0;
            }

            .group-container p {
                display: inline-block;
            }

            .reveal_modules > div p {
                margin: 0 30px 3px 0;
                vertical-align: top;
                display: inline-block;
            }

            .button-container a {
                text-decoration: none;
            }

            .button-container {
                float: right;
            }

            .button-container .btn {
                margin-left: 15px;
                min-width: 100px;
                font-weight: bold;
            }

            {/literal}
        </style>
    </head>
    <body>
    <script type="text/javascript" src="libraries/jquery/jquery.min.js"></script>
    <script>
        {literal}
        jQuery(document).ready(function () {
            var timeout;
            jQuery('.module_list').mouseenter(function (e) {
                thisDiv = jQuery(this);
                timeout = window.setTimeout(function () {
                    hoverHeight = thisDiv.parent(".group-container").height() + 30;
                    hoverWidth = thisDiv.parent(".group-container").width() + 30;
                    thisDiv.siblings('div.reveal_modules').css({'visibility': 'visible', opacity: '0.9'});
                    thisDiv.siblings('div.reveal_modules').stop(true, true).animate({
                        left: '0',
                        top: '0',
                        height: hoverHeight,
                        width: hoverWidth
                    }, 300, function () {
                        jQuery(this).css({'z-index': 610});
                    });
                }, 250);
            }).parent('div.group-container').mouseleave(function (e) {
                jQuery(this).children('div.reveal_modules').stop(true, true).animate({
                    left: '100%',
                    top: '100%',
                    height: 0,
                    width: 0,
                    opacity: 0
                }, 200, function () {
                    jQuery(this).css({'z-index': 600, 'visibility': 'hidden'});
                });
                timeout = window.clearTimeout(timeout);
            });
            jQuery(".selectAll").click(function () {
                if (jQuery(this).is(':checked')) {
                    jQuery("input[type='checkbox']").attr('checked', true);
                    jQuery('.group-container').not(jQuery('.js-basePack')).removeClass('unSelectedContainer').addClass('selectedContainer');

                } else {
                    jQuery("input[type='checkbox']").attr('checked', false);
                    jQuery('.group-container').not(jQuery('.js-basePack')).removeClass('selectedContainer').addClass('unSelectedContainer');
                }
            });
            jQuery("input[type='checkbox']").not(jQuery('.selectAll')).click(function () {
                if (jQuery(this).is(':checked')) {
                    jQuery(this).closest('.group-container').removeClass('unSelectedContainer').addClass('selectedContainer');
                } else {
                    jQuery(this).closest('.group-container').removeClass('selectedContainer').addClass('unSelectedContainer');
                    jQuery(".selectAll").attr('checked', false);
                }
                if (jQuery("input[type='checkbox']:checked").size() === jQuery("input[type='checkbox']").size() - 1) {
                    jQuery(".selectAll").attr('checked', true);
                }
            });
        });
        {/literal}
    </script>
    <div class="container-fluid page-container">
        <div class="row-fluid">
            <div class="span6">
                <div class="logo">
                    <img src="{'logo.png'|vimage_path}"/>
                </div>
            </div>
            <div class="span6"></div>
        </div>
        <div class="row-fluid main-container">
            <div class="span12 inner-container">
                <div class="row-fluid">
                    <div class="span8">
                        <h4 style="display: inline-block;float:left;"> Pretende usar o Magsoft CRM para? </h4>
                    </div>
                    <div class="span4">
                        <div class="pull-right"><strong style="padding-right: 10px;"> Selecionar Todos</strong>
                            <label class="check-switch">
                                <input type="checkbox" name="selectAll" checked="checked" class="selectAll"/>
                                <span></span>
                            </label>
                        </div>
                    </div>
                </div>
                <hr>
                <form id="SystemSetup" class="form" method="POST" action="index.php?module=Users&action=SystemSetupSave">
                    {assign var=COUNTER value=0}
                    {foreach from=$PACKAGES_LIST key=PACKAGE_NAME item=PACKAGE_INFO}
                        {if $COUNTER eq 0 || $COUNTER mod 2 eq 1}
                            <div class="row-fluid">
                        {/if}
                        <div class="group-container {if $COUNTER eq 0} span12 selectedContainer js-basePack {else} selectedContainer span6 {/if}">
                            <div class="module_list"><a> Ver Módulos </a></div>
                            <div class="row-fluid">
                                <div class="{if $COUNTER eq 0} span1 {else} span2 {/if}">
                                    <img src="layouts/vlayout/skins/images/{$PACKAGE_INFO.imageName}" alt="Magsoft Logo"/>
                                </div>
                                <div class="{if $COUNTER eq 0} span11 {else} span10 {/if}">
                                    <div class="group-heading">
                                        <h4>{$PACKAGE_INFO.label}</h4>
                                        {if $COUNTER neq 0}
                                            <div class="pull-right">
                                                <label class="check-switch">
                                                    <input type="checkbox" checked="checked" name="packages[{$PACKAGE_NAME}]"/>
                                                    <span></span>
                                                </label>
                                            </div>
                                        {else}
                                            <div class="basicChkbox"></div>
                                        {/if}
                                    </div>
                                    <div class="group-desc">
                                        <br>
                                        <p>{$PACKAGE_INFO.description}</p>
                                    </div>
                                </div>
                            </div>
                            {if $COUNTER eq 0}
                                <div class="row-fluid">
                                    <div class="offset2 span10" style="margin-top:-25px;">
                                        <input type="hidden" name="packages[{$PACKAGE_NAME}]" value="on"/>
                                        <strong> Estas funcionalidades serão instaladas por defeito </strong></label>
                                    </div>
                                </div>
                            {/if}
                            <div class="reveal_modules">
                                <div>
                                    {* Vtranslate did not supported here *}
                                    <strong>Estes módulos serão ativados</strong>
                                    <hr>
                                    <div>
                                        {assign var=ITEMCOUNTER value=0}
                                        {foreach from=$PACKAGE_INFO.modules item=MODULE_NAME}
                                            <p style="width:25%">{$MODULE_NAME}</p>
                                            {assign var=ITEMCOUNTER value=$ITEMCOUNTER+1}
                                            {if $ITEMCOUNTER eq 3}
                                                <br>
                                                {assign var=ITEMCOUNTER value=0}
                                            {/if}
                                        {/foreach}
                                    </div>
                                </div>
                            </div>
                        </div>
                        {assign var=COUNTER value=$COUNTER+1}
                        {if $COUNTER eq 0 || $COUNTER mod 2 eq 1}
                            </div>
                        {/if}
                    {/foreach}
                    <div class="row-fluid">
                        <div class="span12">
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span9">
                            <strong>Nota: </strong> Poderá ativar ou desativar módulos mais tarde a partir do gestor de módulos.
                        </div>
                        <div class="span3">
                            <div class="button-container">
                                <button type="submit" class="btn btn-large btn-primary next" value="Next"> Seguinte</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </body>
    </html>
{/strip}