{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
*
 ********************************************************************************/
-->*}
{strip}
    <!DOCTYPE html>
    <html>
    <head>
        <title>Magsoft - {$COMPANYNAME}</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0"/>
        <meta content="text/html; charset=UTF-8" http-equiv="Content-Type">
        <!-- Chrome, Firefox OS and Opera -->
        <meta name="theme-color" content="#0074D9">
        <!-- Windows Phone -->
        <meta name="msapplication-navbutton-color" content="#0074D9">
        <!-- iOS Safari -->
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-status-bar-style" content="#0074D9">
        <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
        <!-- for Login page we are added -->
        <link href="libraries/magsoft/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="libraries/magsoft/css/style_login.css" rel="stylesheet" type="text/css"/>
        <link href="libraries/magsoft/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
        <script src="libraries/jquery/jquery.min.js" type="text/javascript"></script>
    </head>
    <body class="fixed-header">
    <div class="login-wrapper">
        <div class="bg-pic">
            {assign var="OverrideImageFile" value='libraries/magsoft/img/background_override.jpg'}
            {if file_exists($OverrideImageFile)}
                <img src="libraries/magsoft/img/background_override.jpg" alt="background" class="lazy"/>
            {else}
                <img src="libraries/magsoft/img/background.jpg" alt="background" class="lazy"/>
            {/if}
            <div class="bg-caption pull-bottom sm-pull-bottom text-white p-l-20 m-b-20">
                <h2 class="semi-bold text-white">{vtranslate('LBL_TEXT_FOOTER_BIG',$MODULE)}</h2>
                <p class="small">{vtranslate('LBL_TEXT_FOOTER_SMALL',$MODULE)}{date('Y')}
                    &nbsp;<a href="https://magsoft.pt" target="_blank" title="Magsoft Crm" style="color: #ffffff; cursor: pointer;">magsoft.pt</a>
                </p>
            </div>
        </div>
        <div class="login-container bg-white">
            <div class="p-l-50 m-l-10 p-r-50 m-r-10 p-t-50 m-t-20 sm-p-l-15 sm-p-r-15 sm-p-t-40">
                <a href="index.php" title="{$COMPANYNAME}"><img style="max-height:55px;" src="{$LOGOURL}" alt="{$COMPANYNAME}" title="{$COMPANYNAME}"></a>
                <div id="loginDiv">
                    {if $NOCONNECTION eq 'true'}
                        <div class="alert alert-danger alert-dismissable fade in">
                            <a href="#" class="close" data-dismiss="alert">&times;</a>
                            <i class="fa fa-database"></i> {vtranslate('LBL_NO_DATABASE_ACCESS',$MODULE)}
                        </div>
                    {/if}
                    <p class="p-t-25">{vtranslate('LBL_RESERVED_AREA',$MODULE)}</p>
                    <form class="p-t-15" role="form" action="index.php?module=Users&action=Login" method="POST" name="form-login">
                        {if isset($smarty.request.error)}
                            <div class="alert alert-danger alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert">&times;</a>
                                <i class="fa fa-exclamation"></i> {vtranslate('LBL_INCORRECT_USER_PASSWORD',$MODULE)}
                            </div>
                        {/if}
                        {if isset($smarty.request.fpError)}
                            <div class="alert alert-danger alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert">&times;</a>
                                <i class="fa fa-exclamation"></i> {vtranslate('LBL_INCORRECT_USER_EMAIL',$MODULE)}
                            </div>
                        {/if}
                        {if isset($smarty.request.status)}
                            <div class="alert alert-success alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert">&times;</a>
                                <i class="fa fa-check"></i> {vtranslate('LBL_EMAIL_SENT_VERIFY',$MODULE)}
                            </div>
                        {/if}
                        {if isset($smarty.request.statusError)}
                            <div class="alert alert-danger alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert">&times;</a>
                                <i class="fa fa-exclamation"></i> {vtranslate('LBL_NO_EMAIL_SERVER',$MODULE)}
                            </div>
                        {/if}
                        <div class="form-group form-group-default">
                            <label><i class="fa fa-user"></i> Username</label>
                            <div class="controls">
                                <input type="text" id="username" name="username" placeholder="{vtranslate('LBL_USERNAME_TEXT',$MODULE)}" class="form-control" required=""/>
                            </div>
                        </div>
                        <div class="form-group form-group-default">
                            <label><i class="fa fa-lock"></i> Password</label>
                            <div class="controls">
                                <input type="password" id="password" name="password" class="form-control" placeholder="{vtranslate('LBL_PASSWORD_TEXT',$MODULE)}" required=""/>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6" style="float:left">
                                <div class="checkbox">
                                    <input type="checkbox" value="1" id="checkbox1"/>
                                    <label for="checkbox1">{vtranslate('LBL_REMEMBER_ME',$MODULE)}</label>
                                </div>
                            </div>
                            <div class="checkbox col-md-6 text-right" style="float:right">
                                <div id="forgotPassword">
                                    <a style="cursor:pointer;" class="text-info small">{vtranslate('LBL_RECOVER_PASSWORD',$MODULE)}</a>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn-primary btn-cons m-t-10 col-md-12" type="submit">{vtranslate('LBL_START_SESSION',$MODULE)}</button>
                    </form>
                </div>
                <div id="forgotPasswordDiv" style="display:none;">
                    <p class="p-t-25">{vtranslate('LBL_RECOVER_PASSWORD',$MODULE)}</p>
                    <form class="p-t-15" role="form" action="forgotPassword.php" method="POST" name="recover-password">
                        <div class="form-group form-group-default">
                            <label><i class="fa fa-user"></i> Username</label>
                            <div class="controls">
                                <input type="text" id="user_name" name="user_name" placeholder="{vtranslate('LBL_USERNAME_TEXT',$MODULE)}" class="form-control" required=""/>
                            </div>
                        </div>
                        <div class="form-group form-group-default">
                            <label><i class="fa fa-envelope"></i> Email</label>
                            <div class="controls">
                                <input type="email" id="emailId" name="emailId" class="form-control" placeholder="{vtranslate('LBL_USERNAME_EMAIL_TEXT',$MODULE)}" required=""/>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="checkbox">
                                    <div id="backButton">
                                        <a class="text-info small" style="cursor:pointer;">{vtranslate('LBL_BACK_TO_LOGIN',$MODULE)}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn-primary btn-cons m-t-10 col-md-12" type="submit" value="Submit" name="retrievePassword">{vtranslate('LBL_RECOVER_PASSWORD',$MODULE)}</button>
                    </form>
                </div>
                <div class="pull-bottom sm-pull-bottom">
                    <div class="m-b-30 p-r-80 sm-m-t-20 sm-p-b-20 clearfix">
                        <div class="col-sm-12 no-padding m-t-10">
                            <p>
                                <small>{vtranslate('LBL_RESERVED_AREA_FOOTER',$MODULE)} {$COMPANYNAME}. {vtranslate('LBL_ARE_YOU_CUSTOMER',$MODULE)}
                                    &nbsp;<a href="{$PORTAL_URL}" class="text-info">{vtranslate('LBL_PORTAL_ACCESS',$MODULE)}</a>
                                </small>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </body>
    <script>
        jQuery(document).ready(function () {
            jQuery("#forgotPassword a").click(function () {
                jQuery("#loginDiv").hide();
                jQuery("#forgotPasswordDiv").show();
            });
            jQuery("#backButton a").click(function () {
                jQuery("#loginDiv").show();
                jQuery("#forgotPasswordDiv").hide();
            });
            /*jQuery("input[name='retrievePassword']").click(function () {
                var username = jQuery('#user_name').val();
                var email = jQuery('#emailId').val();
                var email1 = email.replace(/^\s+/, '').replace(/\s+$/, '');
                var emailFilter = /^[^@]+@[^@.]+\.[^@]*\w\w$/;
                var illegalChars = /[\(\)\<\>\,\;\:\\\"\[\]]/;
                if (username == '') {
                    alert('Coloque um username válido.');
                    return false;
                } else if (!emailFilter.test(email1) || email == '') {
                    alert('Coloque um email válido.');
                    return false;
                } else if (email.match(illegalChars)) {
                    alert("O email contém caracteres inválidos.");
                    return false;
                } else {
                    return true;
                }
            });*/
        });
    </script>
    </html>
{/strip}