<!--/* +********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 * ******************************************************************************* */-->
<!DOCTYPE html>
<html>
<head>
    <title>Repor Password de Utilizador</title>
    <style type="text/css">
        body {
            font-family: Open Sans, "Trebuchet MS", "Lucida Grande", Verdana !important;
            background: #EEEEEE; /*#F5FAEE;*/
            color: #666;
            font-size: 80%;
            height: 98%;
        }

        hr {
            border-top: 1px solid #ddd;
            margin: 13px 0;
            border-bottom: 0;
            border-left: 0;
            border-right: 0;
        }

        #container {
            min-width: 380px;
            width: 60%;
            margin: 0 auto;
        }

        #content {
            padding: 18px 30px;
            border: 1px solid #ddd;
            background: #fff;
            border-radius: 2px;
        }

        .control-label {
        }

        #footer {
            float: right;
        }

        #footer p {
            text-align: right;
            margin-right: 20px;
        }

        .button-container a {
            text-decoration: none;
        }

        .button-container {
            float: left;
        }

        .button-container .btn {
            margin-left: 15px;
            min-width: 100px;
            font-weight: normal;
            border: 0 none !important;
        }

        #btn {
            background-color: #f5f5f5;
            border-image: none;
            border-radius: 4px;
            border-style: solid;
            border-width: 1px;
            box-shadow: none;
            padding: 6px 12px;
            cursor: pointer;
            display: inline-block;
            text-align: center;
            text-shadow: none;
            vertical-align: middle;
        }

        #btn:hover {
            background-color: #e6e6e6;
        }

        .btn-primary {
            background-color: #006dcc;
        }

        .btn-primary:hover {
            background-color: #0044cc;
        }

        .input-table tr td {
            padding: 8px 10px;
            height: 30px;
            text-align: left;
        }

        input, textarea {
            box-shadow: none;
            border-radius: 2px;
            border: 1px solid #dddddd;
            padding: 8px 8px;
        }

        .logo {
            padding: 25px 0 10px 0;
        }
    </style>
    <script language='JavaScript'>
        function checkPassword() {
            var password = document.getElementById('password').value;
            var confirmPassword = document.getElementById('confirmPassword').value;
            if (password == '' && confirmPassword == '') {
                alert('Introduza a sua nova password');
                return false;
            } else if (password != confirmPassword) {
                alert('A confirmação da password não corresponde');
                return false;
            } else {
                return true;
            }
        }
    </script>
</head>
<body>
<div id="container">
    <div class="logo">
        <img src="{$LOGOURL}" alt="{$TITLE}" style="max-height:55px;"><br>
    </div>
    <div>
        {if $LINK_EXPIRED neq 'true'}
        <div id="content">
            <span><b>{vtranslate('LBL_CHANGE_PASSWORD',$MODULE)}</b></span>
            <hr>
            <div id="changePasswordBlock" align='left'>
                <form name="changePassword" id="changePassword" action="{$TRACKURL}" method="post" accept-charset="utf-8">
                    <input type="hidden" name="username" value="{$USERNAME}">
                    <input type="hidden" name="shorturl_id" value="{$SHORTURL_ID}">
                    <input type="hidden" name="secret_hash" value="{$SECRET_HASH}">
                    <table width="80%">
                        <tr>
                            <td>
                                <label class="control-label" for="password">{vtranslate('LBL_NEW_PASSWORD',$MODULE)}</label>
                            </td>
                            <td><input type="password" id="password" name="password" placeholder="nova password"></td>
                        </tr>
                        <tr>
                            <td></td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label" for="confirm_password">{vtranslate('LBL_CONFIRM_PASSWORD',$MODULE)}</label>
                            </td>
                            <td>
                                <input type="password" id="confirmPassword" name="confirmPassword" placeholder="confirmar password">
                            </td>
                        </tr>
                        <tr>
                            <td></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td>
                                <input type="submit" id="btn" class="btn button-container btn-primary" value={vtranslate('Submit', $MODULE)} onclick="return checkPassword();"/>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
            {else}
            <div id="content">
                {vtranslate('LBL_PASSWORD_LINK_EXPIRED_OR_INVALID_PASSWORD', $MODULE)}
            </div>
            {/if}
        </div>
    </div>
</div>
</div>
</div>
</body>
</html>