/**
 * Author : Manuel Pereira
 * Company : Magsoft Crm, Portugal
 * Email : geral@magsoft.pt
 */

jQuery.Class("Settings_TwilioCall_Js", {
    selectedNumbers: false,
    usersList: false,
    hideAddRowButton: function () {
        var countUsers = Object.keys(Settings_TwilioCall_Js.usersList).length;
        var countRows = $('.maprow').length - 1;
        if (countRows >= countUsers) {
            jQuery('#addblankmap').hide();
        } else {
            jQuery('#addblankmap').show();
        }
    },
    updateVoicenoOptions: function () {
        $('.mapvoiceno').each(function () {
            var val = $(this).val();
            $(this)
                .find('option')
                .remove()
                .end();
            $(this).append('<option value=""></option>');
            for (var i = 0; i < Settings_TwilioCall_Js.selectedNumbers.length; i++) {
                var no = Settings_TwilioCall_Js.selectedNumbers[i];
                $(this).append('<option value="' + no + '">' + no + '</option>');
            }

            $(this).val(val);
        });
    },
    updateUsersOptions: function () {
        $('.mapuserid').each(function () {
            var val = $(this).val();
            var ele = $(this);
            ele
                .find('option')
                .remove()
                .end();
            ele.append('<option value=""></option>');
            $.each(Settings_TwilioCall_Js.usersList, function (id, name) {
                ele.append('<option value="' + id + '">' + name + '</option>').trigger('liszt:updated');
            });

            $(this).val(val).trigger('liszt:updated');
        });
    },
    unSelectOption: function (val) {
        $('.activerow div span select option[value="' + val + '"]:selected').attr('selected', false);
    },
    validateMapping: function () {
        var valid = true;
        $('.activerow').each(function () {
            var clientEle = $(this).find('.mapclient');
            var noEle = $(this).find('.mapvoiceno');
            var userEle = $(this).find('.mapuserid');
            if ((clientEle.val().match(/^[0-9a-z]+$/i) == null || clientEle.val() == '') && (noEle.val() != '' && userEle.val() != '')) {
                $(this).css('background', '#ff9999');
                valid = false
            } else {
                $(this).css('background', 'white');
            }
        });
        return valid;
    },
    loadMap: function () {
        var progressIndicatorElement = jQuery.progressIndicator();
        var url = 'index.php?parent=Settings&module=TwilioCall&action=GetData&mode=getEditMap';
        AppConnector.request(url).then(
            function (data) {
                progressIndicatorElement.progressIndicator({'mode': 'hide'});
                if (data.success) {
                    for (var i = 0; i < data.result.length; i++) {
                        var map = data.result[i];
                        $('#hidemaprow').clone().show().addClass('activerow').addClass('map_' + i).removeClass('hide').appendTo('#rowscontainer');
                        Settings_TwilioCall_Js.updateVoicenoOptions();
                        Settings_TwilioCall_Js.updateUsersOptions();
                        $('.map_' + i).find('.mapvoiceno').val(map.phone_number).trigger('liszt:updated');
                        $('.map_' + i).find('.mapuserid').val(map.userid).trigger('liszt:updated');
                        $('.map_' + i).find('.mapclient').val(map.client);
                        Settings_TwilioCall_Js.updateVoicenoOptions();
                        Settings_TwilioCall_Js.updateUsersOptions();
                        jQuery('.removerow').on('click', function (e) {
                            e.currentTarget.closest('.maprow').remove();
                            Settings_TwilioCall_Js.hideAddRowButton();
                        });
                        $('.activerow div span .mapuserid').on('change', function (e) {
                            var val = $(this).val();
                            Settings_TwilioCall_Js.unSelectOption(val);
                            $(this).val(val);
                        });
                        Settings_TwilioCall_Js.hideAddRowButton();
                    }
                }
            }
        );
    },
}, {
    /*
     * function to register the events in DetailView
     */
    registerDetailViewEvents: function () {
        var thisInstance = this;
        //Detail view container
        var container = jQuery('#TwilioSettings');
        var editButton = jQuery('.editButton', container);
        var editMapButton = jQuery('.edimapbutton', container);
        var deleteButton = jQuery('.deleteButton', container);
        var configureMapButton = jQuery('#setupmap');
        var addBlankMapButton = jQuery('#addblankmap');
        var backButton = jQuery('#shownoselector');

        //register click event for edit button
        editButton.click(function (e) {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });

            var url = editButton.data('url');
            location.href = url;
        });

        //register click event for edit button
        editMapButton.click(function (e) {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });

            var url = editMapButton.data('url');
            location.href = url;
        });

        //register click event for edit button
        deleteButton.click(function (e) {
            if (confirm(app.vtranslate('Are you sure you want to delete settings ?'))) {
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position': 'html',
                    'blockInfo': {
                        'enabled': true
                    }
                });

                var url = deleteButton.data('url');
                location.href = url;
            }
        });

        configureMapButton.click(function () {
            Settings_TwilioCall_Js.selectedNumbers = $('.enablednumbers').val();
            var countNos = Settings_TwilioCall_Js.selectedNumbers == null ? 0 : Settings_TwilioCall_Js.selectedNumbers.length;
            if (countNos < 1) {
                Magsoft_Helper_Js.showPnotify(app.vtranslate('Please select atleast one Twilio Number'));
            } else {
                var progressIndicatorElement = jQuery.progressIndicator();
                var url = 'index.php?parent=Settings&module=TwilioCall&action=GetData&mode=getUsersList';
                AppConnector.request(url).then(
                    function (data) {
                        progressIndicatorElement.progressIndicator({'mode': 'hide'});
                        if (data.success) {
                            Settings_TwilioCall_Js.usersList = data.result;
                            $('#noselectorcontainer').hide();
                            $('#noselectorcontainer_desc').hide();
                            configureMapButton.hide();
                            $('.activerow').each(function () {
                                $(this).remove();
                            });
                            $('#mapcontainer').show();
                            Settings_TwilioCall_Js.hideAddRowButton();
                            backButton.show();
                            if ($('#editmap').val() == 'true') {
                                Settings_TwilioCall_Js.loadMap();
                            }
                        }
                    }
                );
            }
        });

        addBlankMapButton.click(function () {
            var countUsers = Object.keys(Settings_TwilioCall_Js.usersList).length;
            var countRows = $('.maprow').length - 1;
            if (countRows >= countUsers) {
                addBlankMapButton.hide();
                Magsoft_Helper_Js.showPnotify(app.vtranslate('No more Users found'));
            } else {
                $('#hidemaprow').clone().show().addClass('activerow').removeClass('hide').appendTo('#rowscontainer');
                Settings_TwilioCall_Js.updateVoicenoOptions();
                Settings_TwilioCall_Js.updateUsersOptions();
                jQuery('.removerow').on('click', function (e) {
                    e.currentTarget.closest('.maprow').remove();
                    Settings_TwilioCall_Js.hideAddRowButton();
                });
                $('.activerow div span .mapuserid').on('change', function (e) {
                    var val = $(this).val();
                    Settings_TwilioCall_Js.unSelectOption(val);
                    $(this).val(val);
                });
                Settings_TwilioCall_Js.hideAddRowButton();
            }

        });

        backButton.click(function () {
            backButton.hide();
            $('#mapcontainer').hide();
            $('#noselectorcontainer').show();
            $('#noselectorcontainer_desc').show();
            configureMapButton.show();
        });


        $('#savemap').on('click', function (e) {
            if (!Settings_TwilioCall_Js.validateMapping()) {
                Magsoft_Helper_Js.showPnotify(app.vtranslate('Please provide valid client name (only characters and digits are allowed) for highlighted configuration.'));
                e.preventDefault();
                return false;
            } else {
                var data = Array();
                $('.activerow').each(function () {
                    var voiceEle = $(this).find('.mapvoiceno');
                    var userEle = $(this).find('.mapuserid');
                    var clientEle = $(this).find('.mapclient');
                    if (voiceEle.val() != '' && userEle.val() != '' && clientEle.val() != '') {
                        var map = Array();
                        map.push(voiceEle.val());
                        map.push(userEle.val());
                        map.push(clientEle.val());
                        data.push(map);
                    }
                });
                if (data.length < 1) {
                    Magsoft_Helper_Js.showPnotify(app.vtranslate('Please provide atleast one mapping.'));
                    return;
                }
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position': 'html',
                    'blockInfo': {
                        'enabled': true
                    }
                });
                var map = JSON.stringify(data);
                var params = {};
                params['module'] = 'TwilioCall';
                params['parent'] = 'Settings';
                params['action'] = 'SaveMap';
                params['selectednumbers'] = Settings_TwilioCall_Js.selectedNumbers;
                params['map'] = map;
                AppConnector.request(params).then(
                    function (data) {
                        if (data.success) {
                            location.href = 'index.php?module=TwilioCall&view=List&parent=Settings';
                        } else {
                            Magsoft_Helper_Js.showPnotify(app.vtranslate('Error occured while saving, please try again.') + 'Twilio error: ' + data.error.code);
                        }
                    },
                    function (error) {
                        progressIndicatorElement.progressIndicator({'mode': 'hide'});
                    }
                );
            }
        });

    },
    registerEvents: function () {
        var thisInstance = this;

        thisInstance.registerDetailViewEvents();


    }

});

jQuery(document).ready(function (e) {
    var instance = new Settings_TwilioCall_Js();
    instance.registerEvents();
    if ($('#editmap').val() == 'true') {
        Settings_TwilioCall_Js.loadTwilioNumbers();
    }
})