{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    <div class="modelContainer" style="width:40em;">
        <div class="modal-header contentsBackground">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            {if $RECORD_ID}
                <h3>{vtranslate('LBL_EDIT_CONFIGURATION', $QUALIFIED_MODULE_NAME)} </h3>
            {else}
                <h3>{vtranslate('LBL_ADD_CONFIGURATION', $QUALIFIED_MODULE_NAME)} </h3>
            {/if}
        </div>
        <form class="form-horizontal" id="smsConfig" method="POST">
            <div class="modal-body configContent" name="configContent">
                <table class="table table-bordered blockContainer showInlineTable equalSplit">
                    <tbody>
                    {if $RECORD_ID}
                        <input type="hidden" value="{$RECORD_ID}" name="record" id="recordId"/>
                    {/if}
                    {foreach item=FIELD_MODEL from=$EDITABLE_FIELDS}
                        <tr>
                            <td class="fieldLabel wide" id="HelpDesk_detailView_fieldLabel_description" style="width:30%">
                                <label class="muted pull-right marginRight10px">
                                    {assign var=FIELD_NAME value=$FIELD_MODEL->get('name')}
                                    <span>
						{vtranslate($FIELD_NAME, $QUALIFIED_MODULE_NAME)}
						</span>
                                </label>
                            </td>
                            <td class="fieldValue wide" colspan="3" style="width:70%;">
                                {assign var=FIELD_TYPE value=$FIELD_MODEL->getFieldDataType()}
                                {assign var=FIELD_VALUE value=$RECORD_MODEL->get($FIELD_NAME)}
                                {if $FIELD_TYPE == 'picklist'}
                                    <select class="chzn-select providerType" name="{$FIELD_NAME}" data-validation-engine="validate[ required,funcCall[Magsoft_Base_Validator_Js.invokeValidation]]">
                                        <option value="">{vtranslate('LBL_SELECT_OPTION','Magsoft')}</option>
                                        {foreach item=PROVIDER_MODEL from=$PROVIDERS}
                                            {assign var=PROVIDER_NAME value=$PROVIDER_MODEL->getName()}
                                            <option value="{$PROVIDER_NAME}" {if $FIELD_VALUE eq $PROVIDER_NAME} selected {/if}>
                                                {vtranslate($PROVIDER_NAME, $QUALIFIED_MODULE_NAME)}
                                            </option>
                                        {/foreach}
                                    </select>
                                {elseif $FIELD_TYPE == 'radio'}
                                    <input type="radio" name="{$FIELD_NAME}" value='1' {if $FIELD_VALUE} checked="checked" {/if} />
                                    &nbsp;{vtranslate('LBL_YES','Magsoft')}&nbsp;&nbsp;&nbsp;
                                    <input type="radio" name="{$FIELD_NAME}" value='0' {if !$FIELD_VALUE} checked="checked" {/if} />
                                    &nbsp;{vtranslate('LBL_NO','Magsoft')}
                                {elseif $FIELD_TYPE == 'password'}
                                    <input type="password" name="{$FIELD_NAME}" class="span3" autocomplete="new-password" data-validation-engine="validate[required]" value="{$FIELD_VALUE}"/>
                                {else}
                                    <input type="text" name="{$FIELD_NAME}" class="span3" {if $FIELD_NAME == 'username'} data-validation-engine="validate[required]" {/if} value="{$FIELD_VALUE}"/>
                                {/if}
                            </td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
                {foreach key=PROVIDER_NAME item=PROVIDER_MODEL from=$PROVIDERS_FIELD_MODELS}
                    <div id="{$PROVIDER_NAME}_container" class="providerFields {if $PROVIDER_NAME neq $RECORD_MODEL->get('providertype')} hide {/if}">
                        {assign var=TEMPLATE_NAME value=Settings_SMSNotifier_ProviderField_Model::getEditFieldTemplateName($PROVIDER_NAME)}
                        {include file=$TEMPLATE_NAME|@vtemplate_path:$QUALIFIED_MODULE_NAME}
                    </div>
                {/foreach}
            </div>
            {include file='ModalFooter.tpl'|@vtemplate_path:$MODULE}
        </form>
    </div>
{/strip}