{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ********************************************************************************/
-->*}
{strip}
    <div class="container-fluid">
        <div class="contents">
            <form id="ConfigEditorForm" class="form-horizontal" data-detail-url="{$MODEL->getDetailViewUrl()}" method="POST">
                <div class="widget_header row-fluid">
                    <div class="span12">
                        <h3>{vtranslate('LBL_CONFIG_EDITOR', $QUALIFIED_MODULE)}</h3>
                        {vtranslate('LBL_CONFIG_DESCRIPTION', $QUALIFIED_MODULE)}
                    </div>
                </div>
                <hr>
                {assign var=WIDTHTYPE value=$CURRENT_USER_MODEL->get('rowheight')}
                {assign var=FIELD_VALIDATION  value=['HELPDESK_SUPPORT_EMAIL_ID' => ['name'=>'Email'],
                'upload_maxsize' => ['name' => 'NumberRange100'],
                'history_max_viewed' => ['name' => 'NumberRange5'],
                'listview_max_textlength' => ['name' => 'NumberRange100'],
                'list_max_entries_per_page' => ['name' => 'NumberRange100']]}
                <table class="table table-bordered detailview-table themeTableColor">
                    <thead>
                    <tr class="blockHeader">
                        <th colspan="2" class="{$WIDTHTYPE}">{vtranslate('LBL_CONFIG_FILE', $QUALIFIED_MODULE)}</th>
                    </tr>
                    </thead>
                    <tbody>
                    {assign var=FIELD_DATA value=$MODEL->getViewableData()}
                    {foreach key=FIELD_NAME item=FIELD_DETAILS from=$MODEL->getEditableFields()}
                        <tr>
                            <td width="40%" class="fieldLabel {$WIDTHTYPE}">
                                <label class="muted pull-right marginRight10px">{vtranslate($FIELD_DETAILS['label'], $QUALIFIED_MODULE)}</label>
                            </td>
                            <td class="row-fluid fieldValue {$WIDTHTYPE}">
                                {if $FIELD_DETAILS['fieldType'] == 'picklist'}
                                    <span class="span5">
									<select class="select2 row-fluid" name="{$FIELD_NAME}">
										{foreach key=optionName item=optionLabel from=$MODEL->getPicklistValues($FIELD_NAME)}
                                            {if $FIELD_NAME != 'default_reply_to'}
                                                <option {if $optionLabel == $FIELD_DATA[$FIELD_NAME]} selected {/if}>{vtranslate($optionLabel, $QUALIFIED_MODULE)}</option>
											{else}
                                                <option value="{$optionName}" {if $optionLabel == $FIELD_DATA[$FIELD_NAME]} selected {/if}>{vtranslate($optionLabel, $optionLabel)}</option>
                                            {/if}
                                        {/foreach}
									</select>
									</span>
                                {elseif $FIELD_NAME == 'email_tracking'}
									<input type="hidden" name="{$FIELD_NAME}" value="No" />
									<label class="check-switch tooltip-right" data-tooltip="{vtranslate('LBL_PERSONAL_EMAIL_TRACKING_INFO', $QUALIFIED_MODULE)}">
										<input type="checkbox" name="{$FIELD_NAME}" value="Yes" {if $FIELD_DATA[$FIELD_NAME] == "Yes"} checked {/if} />
										<span></span>
									</label>
                                {else}
                                	{if $FIELD_NAME == 'upload_maxsize'}
                                		<div class="input-append">
                                    		<input type="text" class="span2" name="{$FIELD_NAME}" data-validation-engine="validate[required, funcCall[Magsoft_Base_Validator_Js.invokeValidation]]" {if $FIELD_VALIDATION[$FIELD_NAME]} data-validator={Zend_Json::encode([$FIELD_VALIDATION[$FIELD_NAME]])} {/if} value="{$FIELD_DATA[$FIELD_NAME]}"/>
                                    		<span class="add-on">{vtranslate('LBL_MB', $QUALIFIED_MODULE)}</span>
                                		</div>
                                	{else}
                                    	<input type="text" name="{$FIELD_NAME}" data-validation-engine="validate[required, funcCall[Magsoft_Base_Validator_Js.invokeValidation]]" {if $FIELD_VALIDATION[$FIELD_NAME]} data-validator={Zend_Json::encode([$FIELD_VALIDATION[$FIELD_NAME]])} {/if} value="{$FIELD_DATA[$FIELD_NAME]}"/>
                                    {/if}
                                {/if}
                            </td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
                <br>
                <div class="row-fluid btn-toolbar">
                	<a type="reset" class="cancelLink" title="{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}">{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}</a>
                    <div class="pull-right">
                        <button class="btn btn-success saveButton" type="submit" title="{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}">
                            <strong>{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</strong>
                        </button>
                    </div>
                </div>
                <br>
            </form>
        </div>
    </div>
{/strip}