{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ********************************************************************************/
-->*}
{strip}
    <div class="relatedTabModulesList" style="padding: 20px 25px;">
        {if empty($RELATED_MODULES)}
            <div class="emptyRelatedTabs">
                <div class="recordDetails">
                    <p class="textAlignCenter">{vtranslate('LBL_NO_RELATED_INFORMATION',$QUALIFIED_MODULE)}</p>
                </div>
            </div>
        {else}
            <div class="relatedListContainer">
                <div class="row-fluid">
                    <h3>{vtranslate('LBL_ARRANGE_RELATED_LIST', $QUALIFIED_MODULE)}</h3>
                </div>
                <br>
                <div class="row-fluid">
				<span class="marginLeftZero">
				<ul class="relatedModulesList marginLeftZero" style="list-style: none;">
				{foreach item=MODULE_MODEL from=$RELATED_MODULES}
                    {if $MODULE_MODEL->isActive()}
                        <li class="relatedModule module_{$MODULE_MODEL->getId()} border1px contentsBackground" style="padding: 8px 8px 4px; margin-bottom:5px;" data-relation-id="{$MODULE_MODEL->getId()}">
						<a><img src="{vimage_path('drag.png')}" title="{vtranslate('LBL_DRAG',$QUALIFIED_MODULE)}"/></a>&nbsp;&nbsp;
						<span class="moduleLabel" style="vertical-align: top;">{vtranslate($MODULE_MODEL->get('label'), $MODULE_MODEL->getRelationModuleName())}</span>
						<button class="close" data-dismiss="modal" title="{vtranslate('LBL_CLOSE')}">x</button>
					</li>
                    {/if}
                {/foreach}
				</ul>
				</span>
                </div>
                <br>
                <div class="row-fluid">
                    <h3>{vtranslate('LBL_SELECT_MODULE_TO_ADD', $QUALIFIED_MODULE)}</h3>
                </div>
                <br>
                <div class="row-fluid">
                    <div>
                        {assign var=ModulesList value=[]}
                        {assign var=removedModuleIds value=array()}
                        <ul style="list-style: none;" class="displayInlineBlock marginLeftZero">
                            <li>
                                <div>
                                    <select class="select2 span6 marginLeftZero" multiple name="addToList" placeholder="{vtranslate('LBL_SELECT_MODULE', $QUALIFIED_MODULE)}">
                                        {foreach item=MODULE_MODEL from=$RELATED_MODULES}
                                            {$ModulesList[$MODULE_MODEL->getId()] = vtranslate($MODULE_MODEL->get('label'), $MODULE_MODEL->getRelationModuleName())}
                                            {if !$MODULE_MODEL->isActive()}
                                                {array_push($removedModuleIds, $MODULE_MODEL->getId())}
                                                <option value="{$MODULE_MODEL->getId()}">
                                                    {vtranslate($MODULE_MODEL->get('label'), $MODULE_MODEL->getRelationModuleName())}
                                                </option>
                                            {/if}
                                        {/foreach}
                                    </select>
                                </div>
                            </li>
                        </ul>
                        <input type="hidden" class="ModulesListArray" value='{ZEND_JSON::encode($ModulesList)}'/>
                        <input type="hidden" class="RemovedModulesListArray" value='{ZEND_JSON::encode($removedModuleIds)}'/>
                    </div>
                </div>
                <br>
                <div class="marginLeftZero alert alert-info">
                    {vtranslate('LBL_RELATED_LIST_INFO', $QUALIFIED_MODULE)}. &nbsp;
                    {vtranslate('LBL_REMOVE_INFO', $QUALIFIED_MODULE)}.&nbsp;
                    {vtranslate('LBL_ADD_MODULE_INFO', $QUALIFIED_MODULE)}
                </div>
                <li class="moduleCopy hide border1px contentsBackground" style="padding: 8px 8px 4px; margin-bottom:5px;">
                    <a>
                        <img src="{vimage_path('drag.png')}" title="{vtranslate('LBL_DRAG',$QUALIFIED_MODULE)}"/>
                    </a>&nbsp;&nbsp;
                    <span class="moduleLabel" style="vertical-align: top;"></span>
                    <button class="close" data-dismiss="modal" title="{vtranslate('LBL_CLOSE')}">&times;</button>
                </li>
            </div>
        {/if}
    </div>
    <br>
    <div class="row-fluid">
        <button class="btn btn-success saveRelatedList pull-right" style="margin-right: 0;" type="button" disabled="disabled">
            <strong>{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</strong></button>
        <br>
    </div>
{/strip}