{*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************}
{strip}
    <div class="editViewContainer container-fluid">
        <form name="EditGroup" action="index.php" method="post" id="EditView" class="form-horizontal">
            <input type="hidden" name="module" value="Groups">
            <input type="hidden" name="action" value="Save">
            <input type="hidden" name="parent" value="Settings">
            <input type="hidden" name="record" value="{$RECORD_MODEL->getId()}">
            <input type="hidden" name="mode" value="{$MODE}">
            <div class="contentHeader row-fluid">
                <h3>
                    {if !empty($MODE)}
                        {vtranslate('LBL_EDITING', $QUALIFIED_MODULE)} {vtranslate('SINGLE_'|cat:$MODULE, $QUALIFIED_MODULE)} - {$RECORD_MODEL->getName()}
                    {else}
                        {vtranslate('LBL_CREATING_NEW', $QUALIFIED_MODULE)} {vtranslate('SINGLE_'|cat:$MODULE, $QUALIFIED_MODULE)}
                    {/if}
                </h3>
                <hr>
            </div>
            
            <table class="table table-bordered detailview-table themeTableColor">
            	<thead>
            		<tr class="blockHeader">
            			{*<th colspan="2" class="wide" style="text-transform: uppercase">
            			{if !empty($MODE)}
                        	{vtranslate('LBL_EDITING', $QUALIFIED_MODULE)} {vtranslate('SINGLE_'|cat:$MODULE, $QUALIFIED_MODULE)} - {$RECORD_MODEL->getName()}
                    	{else}
                        	{vtranslate('LBL_CREATING_NEW', $QUALIFIED_MODULE)} {vtranslate('SINGLE_'|cat:$MODULE, $QUALIFIED_MODULE)}
                    	{/if}
                    	</th>*}
            		</tr>
            	</thead>
            	<tbody>
            		<tr>
            			<td width="25%" class="fieldLabel wide">
            				<label class="muted pull-right marginRight10px">
            					{vtranslate('LBL_GROUP_NAME', $QUALIFIED_MODULE)}<span class="redColor">*</span>
            				</label>
            			</td>
            			<td class="fieldValue wide">
            				<input name="groupname" value="{$RECORD_MODEL->getName()}" data-validation-engine="validate[required]">
            			</td>
            		</tr>
            		<tr>
            			<td class="fieldLabel wide">
            				<label class="muted pull-right marginRight10px">
            					{vtranslate('LBL_DESCRIPTION', $QUALIFIED_MODULE)}
            				</label>
            			</td>
            			<td class="fieldValue wide">
            				<input name="description" id="description" value="{$RECORD_MODEL->getDescription()}"/>
            			</td>
            		</tr>
            		<tr>
            			<td class="fieldLabel wide">
            				<label class="muted pull-right marginRight10px">
            					{vtranslate('LBL_GROUP_MEMBERS', $QUALIFIED_MODULE)}
            				</label>
            			</td>
            			<td class="fieldValue wide">
            			{assign var="GROUP_MEMBERS" value=$RECORD_MODEL->getMembers()}
                        <select id="memberList" class="row-fluid members" multiple="true" name="members[]" data-placeholder="{vtranslate('LBL_ADD_USERS_ROLES', $QUALIFIED_MODULE)}" data-validation-engine="validate[required]">
							{foreach from=$MEMBER_GROUPS key=GROUP_LABEL item=ALL_GROUP_MEMBERS}
                                <optgroup label="{vtranslate($GROUP_LABEL, $QUALIFIED_MODULE)}">
								{foreach from=$ALL_GROUP_MEMBERS item=MEMBER}
                                    {if $MEMBER->getName() neq $RECORD_MODEL->getName()}
                                        <option value="{$MEMBER->getId()}" data-member-type="{$GROUP_LABEL}" {if isset($GROUP_MEMBERS[$GROUP_LABEL][$MEMBER->getId()])}selected="true"{/if}>{$MEMBER->getName()}</option>
                                    {/if}
                                {/foreach}
								</optgroup>
                            {/foreach}
						</select>
            			</td>
            		</tr>
            	</tbody>
            </table>
            <br>
            <div class="well">
                <div>
				<span class="groupMembersColors">
					<span style="margin-right: 6px; border-radius: 2px;" class="Users padding5per textAlignCenter">{vtranslate('LBL_USERS', $QUALIFIED_MODULE)}</span>
					<span style="margin-right: 6px; border-radius: 2px;" class="Groups padding5per textAlignCenter">{vtranslate('LBL_GROUPS', $QUALIFIED_MODULE)}</span>
					<span style="margin-right: 6px; border-radius: 2px;" class="Roles padding5per textAlignCenter">{vtranslate('LBL_ROLES', $QUALIFIED_MODULE)}</span>
					<span style="margin-right: 6px; border-radius: 2px;" class="RoleAndSubordinates padding5per textAlignCenter">{vtranslate('LBL_ROLEANDSUBORDINATE', $QUALIFIED_MODULE)}</span>
				</span>
                </div>
            </div>
            <div class="row-fluid">
            		<a class="cancelLink" type="reset" onclick="javascript:window.history.back();">{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}</a>
					<span class="pull-right">
						<button class="btn btn-success" type="submit"><strong>{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</strong></button>
					</span>
            </div>
        </form>
    </div>
{/strip}