{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    <span class="span tooltip-right" data-tooltip="{vtranslate($MODULE_NAME)}">
    	<img src='{vimage_path("summary_{$MODULE_NAME}.png")}' class="summaryImg"/>
    </span>
    <span class="span10">
        <span class="row-fluid">
            <h4 class="recordLabel pushDown" title="{$RECORD->getName()}">
                {foreach item=NAME_FIELD from=$MODULE_MODEL->getNameFields()}
                    {assign var=FIELD_MODEL value=$MODULE_MODEL->getField($NAME_FIELD)}
                    {if $FIELD_MODEL->getPermissions()}
                        <span>{$RECORD->getDisplayValue('salesorder_no')}</span>
                        &nbsp;-&nbsp;
                        <span class="{$NAME_FIELD}">{$RECORD->get($NAME_FIELD)}</span>
                    {/if}
                {/foreach}
            </h4>
        </span>
        <span class="row-fluid">
            {assign var=STATUS value=$RECORD->get('sostatus')}
            {if !empty($STATUS)}
            <span class="muted">{vtranslate('LBL_STATUS',$MODULE_NAME)} - </span>
            {if $STATUS|strstr:'Created'}
                <span class="sostatus_label color-blue">{$RECORD->getDisplayValue('sostatus')}</span>
            {elseif $STATUS|strstr:'Cancelled'}
                <span class="sostatus_label color-red">{$RECORD->getDisplayValue('sostatus')}</span>
            {elseif $STATUS|strstr:'Approved'}
            	<span class="sostatus_label color-green">{$RECORD->getDisplayValue('sostatus')}</span>
            {elseif $STATUS|strstr:'Delivered'}
                <span class="sostatus_label color-green"><i class="fa fa-check" aria-hidden="true"></i> {$RECORD->getDisplayValue('sostatus')}</span>
            {else}
                <span class="sostatus_label color-yellow">{$RECORD->getDisplayValue('sostatus')}</span>
            {/if}
            {/if}
            {assign var=GRANDTOTAL value=$RECORD->get('hdnGrandTotal')}
            {if !empty($GRANDTOTAL) && ($GRANDTOTAL neq '0')}
                {assign var=CURRENCY_SYMBOL_PLACEMENT value={$CURRENT_USER_MODEL->get('currency_symbol_placement')}}
                {if !empty($STATUS)}
                &nbsp;-&nbsp;
                {/if}
                <span class="hdnGrandTotal_label color-blue">
        			{if $CURRENCY_SYMBOL_PLACEMENT eq '1.0$'}
                        {$RECORD->getDisplayValue('hdnGrandTotal')} {$USER_MODEL->get('currency_symbol')}
                    {else}
                        {$USER_MODEL->get('currency_symbol')} {$RECORD->getDisplayValue('hdnGrandTotal')}
                    {/if}
                </span>
            {/if}
        </span>
    </span>
{/strip}