{*<!--
/*********************************************************************************
  ** The contents of this file are subject to the magsoft CRM Public License Version 1.0
   * ("License"); You may not use this file except in compliance with the License
   * The Original Code is:  magsoft CRM Software
   * The Initial Developer of the Original Code is magsoft.
   * Portions created by magsoft are Copyright (C) magsoft.
   * All Rights Reserved.
  *
 ********************************************************************************/
-->*}
<div class="modelContainer" style="min-width: 350px">
    <div class="modal-header contentsBackground">
        <button class="close" aria-hidden="true" data-dismiss="modal" type="button" title="{vtranslate('LBL_CLOSE')}">&times;</button>
        <h3>Sms - Report</h3>
    </div>
    <form class="form-horizontal recordEditView" name="QuickCreate" method="post" action="index.php">
        <div class="quickCreateContent">
            <div class="modal-body">
                <table class="massEditTable table table-bordered">
                    <thead>
                    {if $IS_MOBILE neq "true"}
                        <tr>
                            <th class="blockHeader" colspan="4">
                                {vtranslate('LBL_SMSNOTIFIER_INFORMATION_STATUS',$MODULE_NAME)}
                            </th>
                        </tr>
                    {/if}
                    </thead>
                    <tbody>
                    {if $IS_MOBILE eq "true"}
                        <tr>
                            <th class="blockHeader">
                                {vtranslate('LBL_TO_NUMBER',$MODULE_NAME)}
                            </th>
                            <th class="blockHeader">
                                {vtranslate('LBL_SMS_STATUS',$MODULE_NAME)}
                            </th>
                        </tr>
                    {/if}
                    {foreach item=RESULT from=$RECORD->get('messagedetails') name=NUMBERSECTION}
                        {assign var="TDSTATUSCOLOR" value="#FFFFFF"}
                        {if $RESULT.status == 'Processing'}
                            {assign var="TDSTATUSCOLOR" value="#FFFF00"}
                        {elseif $RESULT.status == 'Dispatched'}
                            {assign var="TDSTATUSCOLOR" value="#BDF97D"}
                        {elseif $RESULT.status == 'Delivered'}
                            {assign var="TDSTATUSCOLOR" value="#BDF97D"}
                        {elseif $RESULT.status eq 'Failed'}
                            {assign var="TDSTATUSCOLOR" value="#FF3322"}
                            {*{elseif $RESULT.status eq 'Error'}*}
                        {elseif $RESULT.status|strstr:'ERR'}
                            {assign var="TDSTATUSCOLOR" value="#FB6B5B"}
                        {else}
                            {assign var="TDSTATUSCOLOR" value="#99FFEE"}
                        {/if}
                        <tr>
                            {if $IS_MOBILE eq "true"}
                                <td class="fieldLabel {$WIDTHTYPE}">
                                    <label class="muted pull-right">
                                        {$RESULT.tonumber}
                                    </label>
                                </td>
                                <td class="fieldValue {$WIDTHTYPE}" bgcolor="{$TDSTATUSCOLOR}">
                                    {$RESULT.status}
                                </td>
                            {else}
                                <td class="fieldLabel {$WIDTHTYPE}">
                                    <label class='muted pull-right marginRight10px'>{vtranslate('LBL_TO_NUMBER',$MODULE_NAME)}</label>
                                </td>
                                <td class="fieldValue {$WIDTHTYPE}">
                                    <span class="value">
                                        {$RESULT.tonumber}
                                    </span>
                                </td>
                                <td class="fieldLabel {$WIDTHTYPE}">
                                    <label class='muted pull-right marginRight10px'>{vtranslate('LBL_SMS_STATUS',$MODULE_NAME)}</label>
                                </td>
                                <td class="fieldValue {$WIDTHTYPE}" bgcolor="{$TDSTATUSCOLOR}">
                                    <span class="value">
                                        {$RESULT.status}
                                    </span>
                                </td>
                            {/if}
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
        <div class="modal-footer quickCreateActions">
            <a class="cancelLink cancelLinkContainer pull-right" type="reset" data-dismiss="modal">{vtranslate('LBL_CANCEL', $MODULE)}</a>
        </div>
    </form>
</div>