/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/

Inventory_Edit_Js("Quotes_Edit_Js", {}, {

    /**
     * Function which will register event for Reference Fields Selection
     */
    registerReferenceSelectionEvent: function (container) {
        this._super(container);
        var thisInstance = this;

        jQuery('input[name="account_id"]', container).on(Magsoft_Edit_Js.referenceSelectionEvent, function (e, data) {
            thisInstance.referenceSelectionEventHandler(data, container);
        });
    },

    /**
     * Function to get popup params
     */
    getPopUpParams: function (container) {
        var params = this._super(container);
        var sourceFieldElement = jQuery('input[class="sourceField"]', container);

        if (sourceFieldElement.attr('name') == 'contact_id' || sourceFieldElement.attr('name') == 'potential_id') {
            var form = this.getForm();
            var parentIdElement = form.find('[name="account_id"]');
            if (parentIdElement.length > 0 && parentIdElement.val().length > 0 && parentIdElement.val() != 0) {
                var closestContainer = parentIdElement.closest('td');
                params['related_parent_id'] = parentIdElement.val();
                params['related_parent_module'] = closestContainer.find('[name="popupReferenceModule"]').val();
            } else if (sourceFieldElement.attr('name') == 'potential_id') {
                parentIdElement = form.find('[name="contact_id"]');
                if (parentIdElement.length > 0 && parentIdElement.val().length > 0) {
                    closestContainer = parentIdElement.closest('td');
                    params['related_parent_id'] = parentIdElement.val();
                    params['related_parent_module'] = closestContainer.find('[name="popupReferenceModule"]').val();
                }
            }
        }
        return params;
    },

    /**
     * Function to search module names
     */
    searchModuleNames: function (params) {
        var aDeferred = jQuery.Deferred();

        if (typeof params.module == 'undefined') {
            params.module = app.getModuleName();
        }
        if (typeof params.action == 'undefined') {
            params.action = 'BasicAjax';
        }

        if (params.search_module == 'Contacts' || params.search_module == 'Potentials') {
            var form = this.getForm();
            var parentIdElement = form.find('[name="account_id"]');
            if (parentIdElement.length > 0 && parentIdElement.val().length > 0) {
                var closestContainer = parentIdElement.closest('td');
                params.parent_id = parentIdElement.val();
                params.parent_module = closestContainer.find('[name="popupReferenceModule"]').val();
            } else if (params.search_module == 'Potentials') {
                parentIdElement = form.find('[name="contact_id"]');
                if (parentIdElement.length > 0 && parentIdElement.val().length > 0) {
                    closestContainer = parentIdElement.closest('td');
                    params.parent_id = parentIdElement.val();
                    params.parent_module = closestContainer.find('[name="popupReferenceModule"]').val();
                }
            }
        }

        AppConnector.request(params).then(
            function (data) {
                aDeferred.resolve(data);
            },
            function (error) {
                aDeferred.reject();
            }
        )
        return aDeferred.promise();
    },

    registerEvents: function () {
        this._super();
        this.registerForTogglingBillingandShippingAddress();
        this.registerEventForCopyAddress();
    }
});


