jQuery(document).ready(function () {
    var current_url = jQuery.url();
    var module = current_url.param('module');
    var view = current_url.param('view');
    var action = current_url.param('action');
    var record = current_url.param('record');

    jQuery('body').on('click', '#popupalert_create_new_button', function () {


        var actionParams = {
            "view": "index",
            "mode": "showCreatingBox",
            "module": "PopupAlert"
        };
        AppConnector.request(actionParams).then(
            function (data) {
                if (data) {
                    app.showModalWindow(data, {'text-align': 'left'});
                }
            },
            function (error, err) {

            }
        );
    });

    jQuery('body').on('click', '#save_alert', function () {
        var vals = jQuery('form[name=CreateAlert]').serialize();
        var current_url = jQuery.url();
        var record = current_url.param('record');
        var actionParams = {
            "action": "Ajax",
            "mode": "Save",
            "module": "PopupAlert",
            "vals": vals,
            "record": record
        };
        AppConnector.request(actionParams).then(
            function (data) {
                reloadPopupAlertWidget();
                app.hideModalWindow();
            },
            function (error, err) {

            }
        );
    });

    jQuery('body').on('click', '#close_alert', function () {
        app.hideModalWindow();
        jQuery(this).closest('.modalalert_box').modal('hide');
    });

    jQuery('body').on('click', '#delete_alert', function () {
        var delete_button = jQuery(this);
        var pa_id = jQuery('form[name=AlertBox] #pa_id').val();
        var actionParams = {
            "action": "Ajax",
            "mode": "Delete",
            "module": "PopupAlert",
            "pa_id": pa_id
        };
        AppConnector.request(actionParams).then(
            function (data) {
                reloadPopupAlertWidget();
                app.hideModalWindow();
                jQuery(delete_button).closest('.modalalert_box').modal('hide');
            },
            function (error, err) {

            }
        );
    });

    if (view != 'Edit') {
        var actionParams = {
            "action": "Ajax",
            "mode": "getAvailableAlerts",
            "module": "PopupAlert",
            "record": record,
            "source_module": module
        };
        AppConnector.request(actionParams).then(
            function (data) {
                if (data) {
                    jQuery(data.result).each(function () {
                        var pa_id = this.pa_id;

                        var actionParams = {
                            "view": "index",
                            "mode": "openAlert",
                            "module": "PopupAlert",
                            "pa_id": pa_id
                        };
                        AppConnector.request(actionParams).then(
                            function (data) {
                                if (data) {
                                    var html = '<div class="modal fade modalalert_box" id="alertmodal_' + pa_id + '" style="padding:0;">' +
                                        '<div class="modal-dialog">' +
                                        '<div class="modal-content">' +
                                        '<div class="modal-body" style="padding:0;"></div></div></div></div>';
                                    jQuery('#rightPanel').append(html);
                                    var quickCreateFormShipment = jQuery('#alertmodal_' + pa_id + ' .modal-body');
                                    quickCreateFormShipment.html(data);
                                    jQuery('#alertmodal_' + pa_id).on('hidden', function () {
                                        jQuery('.blockUI').show();
                                        //jQuery('body').addClass('modal-open');
                                    }).modal('show');
                                }
                            },
                            function (error, err) {

                            }
                        );


                    });
                }
            },
            function (error, err) {

            }
        );
    }


});

function openPAlert(pa_id) {
    var actionParams = {
        "view": "index",
        "mode": "openAlert",
        "module": "PopupAlert",
        "pa_id": pa_id
    };
    AppConnector.request(actionParams).then(
        function (data) {
            if (data) {
                app.showModalWindow(data, {'text-align': 'left'});
            }
        },
        function (error, err) {

        }
    );
}

function reloadPopupAlertWidget() {
    var widgetContainer = jQuery('#popup_alert_widget').parent();
    var url = widgetContainer.data('url');
    var listViewWidgetParams = {
        "type": "GET", "url": "index.php",
        "dataType": "html", "data": url
    }
    AppConnector.request(listViewWidgetParams).then(
        function (data) {
            if (typeof open == 'undefined') open = true;
            if (open) {
                widgetContainer.progressIndicator({'mode': 'hide'});
                var imageEle = widgetContainer.parent().find('.imageElement');
                var imagePath = imageEle.data('downimage');
                imageEle.attr('src', imagePath);
                widgetContainer.css('height', 'auto');
            }
            widgetContainer.html(data);
            var label = widgetContainer.closest('.quickWidget').find('.quickWidgetHeader').data('label');
            jQuery('.bodyContents').trigger('Magsoft.Widget.Load.' + label, jQuery(widgetContainer));
        }
    );
}
