/*********************************************************************************
 * The content of this file is subject to the PDF Maker license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is Magsoft Crm Software
 * Portions created by Magsoft Crm Software are Copyright(C) Magsoft Crm Software
 * All Rights Reserved.
 ********************************************************************************/

if (typeof (PDFMaker_ImportJs) == 'undefined') {
    /*
     * Namespaced javascript class for Import
     */
    PDFMaker_ImportJs = {
        checkFileType: function () {
            var filePath = jQuery('#import_file').val();
            if (filePath != '') {
                var fileExtension = filePath.split('.').pop();
                jQuery('#type').val(fileExtension);
                PDFMaker_ImportJs.handleFileTypeChange();
            } else
                return false;
        },
        handleFileTypeChange: function () {
            var fileType = jQuery('#type').val();
            var delimiterContainer = jQuery('#delimiter_container');
            var hasHeaderContainer = jQuery('#has_header_container');
            if (fileType != 'xml') {
                delimiterContainer.hide();
                hasHeaderContainer.hide();
            }
        },
        uploadAndParse: function () {
            if (!PDFMaker_ImportJs.validateFilePath())
                return false;
            return true;
        },
        validateFilePath: function () {
            var importFile = jQuery('#import_file');
            var filePath = importFile.val();
            if (jQuery.trim(filePath) == '') {
                var errorMessage = app.vtranslate('JS_IMPORT_FILE_CAN_NOT_BE_EMPTY');
                var params = {
                    text: errorMessage,
                    type: 'error'
                };
                Magsoft_Helper_Js.showMessage(params);
                importFile.focus();
                return false;
            }
            if (!PDFMaker_ImportJs.uploadFilter("import_file", "xml")) {
                return false;
            }
            if (!PDFMaker_ImportJs.uploadFileSize("import_file")) {
                return false;
            }
            return true;
        },
        uploadFilter: function (elementId, allowedExtensions) {
            var obj = jQuery('#' + elementId);
            if (obj) {
                var filePath = obj.val();
                var fileParts = filePath.toLowerCase().split('.');
                var fileType = fileParts[fileParts.length - 1];
                var validExtensions = allowedExtensions.toLowerCase().split('|');

                if (validExtensions.indexOf(fileType) < 0) {
                    var errorMessage = app.vtranslate('JS_SELECT_FILE_EXTENSION') + '\n' + validExtensions;
                    var params = {
                        text: errorMessage,
                        type: 'error'
                    };
                    Magsoft_Helper_Js.showMessage(params);
                    obj.focus();
                    return false;
                }
            }
            return true;
        },
        uploadFileSize: function (elementId) {
            /*var element = jQuery('#' + elementId);
             var importMaxUploadSize = element.closest('td').data('importUploadSize');
             var uploadedFileSize = element.get(0).files[0].size;
             if (uploadedFileSize > importMaxUploadSize) {
             var errorMessage = app.vtranslate('JS_UPLOADED_FILE_SIZE_EXCEEDS') + " " + "3 MB." + app.vtranslate('JS_PLEASE_SPLIT_FILE_AND_IMPORT_AGAIN');
             var params = {
             text: errorMessage,
             type: 'error'
             };
             Magsoft_Helper_Js.showMessage(params);
             return false;
             }*/
            return true;
        },
        registerImportClickEvent: function () {
            jQuery('#importButton').on('click', function (e) {
                var result = PDFMaker_ImportJs.checkFileType()
                return result;
            });
        }
    }
    jQuery(document).ready(function () {
        PDFMaker_ImportJs.registerImportClickEvent();
    });
}