/*********************************************************************************
 * The content of this file is subject to the PDF Maker license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is Magsoft Crm Software
 * Portions created by Magsoft Crm Software are Copyright(C) Magsoft Crm Software
 * All Rights Reserved.
 ********************************************************************************/

jQuery.Class("PDFMaker_Extensions_Js", {}, {

    registerActions: function () {

        var aDeferred = jQuery.Deferred();
        jQuery('#install_Workflow_btn').click(function (e) {
            //thisInstance.editLicense('activate');

            var extname = jQuery(e.currentTarget).data('extname');

            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });

            //jQuery('#w_install_loading_icon').removeClass('hide').show();
            //jQuery(e.currentTarget).hide();

            var params = {
                'module': 'PDFMaker',
                'action': 'IndexAjax',
                'mode': 'installExtension',
                'extname': extname
            };

            AppConnector.request(params).then(
                function (data) {
                    var response = data['result'];
                    var result = response['success'];
                    progressIndicatorElement.progressIndicator({'mode': 'hide'});

                    if (result == true) {

                        jQuery(e.currentTarget).hide();
                        jQuery('#install_' + extname + '_info').html(response['message']);
                        jQuery('#install_' + extname + '_info').removeClass('hide');

                        var params = {
                            text: response['message'],
                            type: 'info'
                        };

                        Magsoft_Helper_Js.showMessage(params);

                    } else {
                        var ismodal = jQuery(response['message']).find('div');
                        if (ismodal.length > 0) {
                            app.showModalWindow(response['message']);
                        } else {
                            var params = {
                                text: response['message'],
                                type: 'error'
                            };
                            Magsoft_Helper_Js.showMessage(params);
                        }
                    }
                },
                function (error, err) {
                    aDeferred.reject();
                    progressIndicatorElement.progressIndicator({'mode': 'hide'});
                }
            );

        });
        jQuery('.RTF_btn').click(function (e) {
            var extname = jQuery(e.currentTarget).data('extname');
            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });

            var url = jQuery(e.currentTarget).data('url');

            window.location.href = url;
        });
    },

    registerEvents: function () {
        this.registerActions();
    },

    showMessage: function (customParams) {
        var params = {};
        params.animation = "show";
        params.type = 'info';
        params.title = app.vtranslate('JS_MESSAGE');

        if (typeof customParams != 'undefined') {
            var params = jQuery.extend(params, customParams);
        }
        Magsoft_Helper_Js.showPnotify(params);


    }
});
