{*<!--
/************************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*************************************************************************************/
-->*}
{strip}
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <title>Atualização Magsoft</title>
        <link rel="icon" href="favicon.ico">
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css" integrity="sha384-9aIt2nRpC12Uk9gS9baDl411NQApFmC26EwAOH8WgZl5MYYxFfc+NcPb1dKGj7Sk" crossorigin="anonymous">
        <script type="text/javascript" src="libraries/jquery/jquery.min.js"></script>
    </head>
    <body class="bg-light">
    <div class="container">
        <div class="py-5 text-center">
            <img class="d-block mx-auto mb-4" src="test/logo/icon.png" alt="" width="53" height="65">
            <h2>Atualização Magsoft</h2>
            <p class="lead">A seguinte atualização requer acesso ao crm para poder finalizar a instalação. Para atualizações manuais, verifique
                <a href="https://magsoft.pt/documentation/#line9" target="_blank"> aqui</a>.</p>
        </div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Magsoft</a></li>
                <li class="breadcrumb-item active" aria-current="page">Atualização Crm</li>
            </ol>
        </nav>
        <div class="container">
            <div class="row">
                <div class="col-md-12 order-md-1">
                    <div id="running" class="text-center"><br>
                        <h4 class="mb-3">{vtranslate('LBL_WAIT',$MODULE)}</h4><br>
                        <h4 class="mb-3">{vtranslate('LBL_INPROGRESS',$MODULE)}</h4><br>
                        <div class="spinner-grow text-primary" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <div class="spinner-grow text-secondary" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <div class="spinner-grow text-success" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <div class="spinner-grow text-danger" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <div class="spinner-grow text-warning" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <div class="spinner-grow text-info" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <div class="spinner-grow text-dark" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                    </div>
                    <div id="success" style="display: none"><br>
                        <h5 class="mb-3">{vtranslate('LBL_DATABASE_CHANGE_LOG',$MODULE)}</h5>
                    </div>
                    <div id="showDetails" style="display: none"></div>
                    <div id="successFinish" style="display: none"><br>
                        <h5 class="mb-3">{vtranslate('LBL_MIGRATION_COMPLETED_SUCCESSFULLY',$MODULE)}</h5>
                    </div>
                    <div id="nextButton" style="display: none">
                        <form action='index.php' method="POST">
                            <input type="hidden" id="module" name="module" value="Migration">
                            <input type="hidden" id="view" name="view" value="Index">
                            <div class="button-container">
                                <hr class="mb-4">
                                <input type="button" onclick="window.location.href='autoupdate/update.php'" class="btn btn-primary btn-lg btn-block" value="{vtranslate('LBL_NEXT', $MODULE)}"/>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <footer class="my-5 pt-5 text-muted text-center text-small">
                <p class="mb-1">&copy; 2017-2020 Magsoft Crm</p>
                <ul class="list-inline">
                    <li class="list-inline-item"><a href="https://magsoft.pt" target="_blank">Magsoft Site</a>
                    </li>
                    <li class="list-inline-item">
                        <a href="https://magsoft.pt/documentation" target="_blank">Documentação</a>
                    </li>
                    <li class="list-inline-item">
                        <a href="https://clientes.ptdesign.pt" target="_blank">Suporte Cliente</a>
                    </li>
                </ul>
            </footer>
        </div>
    </div>
    </body>
    </html>
{/strip}