/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/

var Magsoft_Index_Js = {

    /**
     * Function to show email preview in popup
     */
    showEmailPreview: function (recordId, parentId) {
        var popupInstance = Magsoft_Popup_Js.getInstance();
        var params = {};
        params['module'] = "Emails";
        params['view'] = "ComposeEmail";
        params['mode'] = "emailPreview";
        params['record'] = recordId;
        params['parentId'] = parentId;
        params['relatedLoad'] = true;
        popupInstance.show(params);
    },

    registerWidgetsEvents: function () {
        var widgets = jQuery('div.widgetContainer');
        widgets.on({
            shown: function (e) {
                var widgetContainer = jQuery(e.currentTarget);
                Magsoft_Index_Js.loadWidgets(widgetContainer);
                var key = widgetContainer.attr('id');
                app.cacheSet(key, 1);
            },
            hidden: function (e) {
                var widgetContainer = jQuery(e.currentTarget);
                var imageEle = widgetContainer.parent().find('.imageElement');
                var imagePath = imageEle.data('rightimage');
                imageEle.attr('src', imagePath);
                var key = widgetContainer.attr('id');
                app.cacheSet(key, 0);
            }
        });
    },

    /**
     * Function is used to load the sidebar widgets
     * @param widgetContainer - widget container
     * @param open - widget should be open or closed
     */
    loadWidgets: function (widgetContainer, open) {
        var message = jQuery('.loadingWidgetMsg').html();

        if (widgetContainer.html() != '') {
            var imageEle = widgetContainer.parent().find('.imageElement');
            var imagePath = imageEle.data('downimage');
            imageEle.attr('src', imagePath);
            widgetContainer.css('height', 'auto');
            return;
        }

        widgetContainer.progressIndicator({'message': message});
        var url = widgetContainer.data('url');

        var listViewWidgetParams = {
            "type": "GET", "url": "index.php",
            "dataType": "html", "data": url
        }
        AppConnector.request(listViewWidgetParams).then(
            function (data) {
                if (typeof open == 'undefined') {
                    open = true;
                }
                if (open) {
                    widgetContainer.progressIndicator({'mode': 'hide'});
                    var imageEle = widgetContainer.parent().find('.imageElement');
                    var imagePath = imageEle.data('downimage');
                    imageEle.attr('src', imagePath);
                    widgetContainer.css('height', 'auto');
                }
                widgetContainer.html(data);
                var label = widgetContainer.closest('.quickWidget').find('.quickWidgetHeader').data('label');
                jQuery('.bodyContents').trigger('Magsoft.Widget.Load.' + label, jQuery(widgetContainer));
            }
        );
    },

    loadWidgetsOnLoad: function () {
        var widgets = jQuery('div.widgetContainer');
        widgets.each(function (index, element) {
            var widgetContainer = jQuery(element);
            var key = widgetContainer.attr('id');
            var value = app.cacheGet(key);
            if (value != null) {
                if (value == 1) {
                    Magsoft_Index_Js.loadWidgets(widgetContainer);
                    widgetContainer.addClass('in');
                } else {
                    var imageEle = widgetContainer.parent().find('.imageElement');
                    var imagePath = imageEle.data('rightimage');
                    imageEle.attr('src', imagePath);
                }
            }

        });

    },

    /**
     * Function to change user theme(colour)
     * @params : colour name
     */
    changeSkin: function () {
        jQuery('.themeElement').on('click', function (e) {
            e.stopPropagation();
            var currentElement = jQuery(e.currentTarget);
            currentElement.closest('#themeContainer').hide();

            var progressElement = jQuery('#progressDiv');
            progressElement.progressIndicator({'smallLoadingImage': true});

            var params = {
                'module': 'Users',
                'action': 'SaveAjax',
                'record': jQuery('#current_user_id').val(),
                'field': 'theme',
                'value': currentElement.data('skinName')
            }
            AppConnector.request(params).then(function (data) {
                    if (data.success && data.result) {
                        progressElement.progressIndicator({'mode': 'hide'});
                        jQuery('.settingIcons').removeClass('open');
                        window.location.reload();
                    }
                },
                function (error, err) {
                });
        })
    },

    /**
     * Function to show compose email popup based on number of
     * email fields in given module,if email fields are more than
     * one given option for user to select email for whom mail should
     * be sent,or else straight away open compose email popup
     * @params : accepts params object
     *
     * @cb: callback function to recieve the child window reference.
     */

    showComposeEmailPopup: function (params, cb) {
        var currentModule = "Emails";
        Magsoft_Helper_Js.checkServerConfig(currentModule).then(function (data) {
            if (data == true) {
                var css = jQuery.extend({'text-align': 'left'}, css);
                AppConnector.request(params).then(
                    function (data) {
                        var cbargs = [];
                        if (data) {
                            data = jQuery(data);
                            var form = data.find('#SendEmailFormStep1');
                            var emailFields = form.find('.emailField');
                            var length = emailFields.length;
                            var emailEditInstance = new Emails_MassEdit_Js();
                            if (length > 1) {
                                app.showModalWindow(data, function (data) {
                                    emailEditInstance.registerEmailFieldSelectionEvent();
                                    if (jQuery('#multiEmailContainer').height() > 300) {
                                        jQuery('#multiEmailContainer').slimScroll({
                                            height: '300px',
                                            railVisible: true,
                                            alwaysVisible: true,
                                            size: '6px'
                                        });
                                    }
                                }, css);
                            } else {
                                emailFields.attr('checked', 'checked');
                                var params = form.serializeFormData();
                                // http://stackoverflow.com/questions/13953321/how-can-i-call-a-window-child-function-in-javascript
                                // This could be useful for the caller to invoke child window methods post load.
                                var win = emailEditInstance.showComposeEmailForm(params);
                                cbargs.push(win);
                            }
                        }
                        if (typeof cb == 'function') {
                            cb.apply(null, cbargs);
                        }
                    },
                    function (error, err) {

                    }
                );
            } else {
                var pnotparams = {
                    title: app.vtranslate('JS_EMAIL_SERVER_CONFIGURATION_TITLE'),
                    text: app.vtranslate('JS_EMAIL_SERVER_CONFIGURATION'),
                    animation: 'show',
                    icon: 'fa fa-envelope-open-o',
                    type: 'error'
                };
                Magsoft_Helper_Js.showPnotify(pnotparams);
                //Magsoft_Helper_Js.showPnotify(app.vtranslate('JS_EMAIL_SERVER_CONFIGURATION'));
            }
        })

    },

    /**
     * Function registers event for Calendar Reminder popups
     */
    registerActivityReminder: function () {
        var activityReminder = jQuery('#activityReminder').val();
        activityReminder = activityReminder * 1000;
        if (activityReminder != '') {
            var currentTime = new Date().getTime() / 1000;
            var nextActivityReminderCheck = app.cacheGet('nextActivityReminderCheckTime', 0);
            if ((currentTime + activityReminder) > nextActivityReminderCheck) {
                Magsoft_Index_Js.requestReminder();
                setTimeout('Magsoft_Index_Js.requestReminder()', activityReminder);
                app.cacheSet('nextActivityReminderCheckTime', currentTime + parseInt(activityReminder));
            }
        }
    },

    /**
     * Function request for reminder popups
     */
    requestReminder: function () {
        var url = 'index.php?module=Calendar&action=ActivityReminder&mode=getReminders';
        AppConnector.request(url).then(function (data) {
            if (data.success && data.result) {
                for (i = 0; i < data.result.length; i++) {
                    var record = data.result[i];
                    Magsoft_Index_Js.showReminderPopup(record);
                }
            }
        });
    },

    /**
     * Function display the Reminder popup
     */
    showReminderPopup: function (record) {
        var params = {
            title: '&nbsp;<span>' + record.activitytype + ' - ' +
            '<a href="index.php?module=Calendar&view=Detail&record=' + record.id + '">' + record.subject + '</a></span>',
            text: '<div class="row-fluid">\n\
				<span class="span6 marginLeftZero">' + app.vtranslate('JS_START_DATE_TIME') + ':\n\ ' + record.date_start + '</span><span class="span6">' + app.vtranslate('JS_END_DATE_TIME') + ':\n\ ' + record.due_date + '</span>' +
            '<span class="span marginLeftZero paddingtop10"><a id="reminder_' + record.id + '" class="color-red btn-mini" href=#>' + app.vtranslate('JS_POSTPONE') + '</a></span></div>',
            width: '35%',
            min_height: '70px',
            addclass: 'vtReminder',
            icon: 'fa fa-check-square-o',
            hide: false,
            closer: true,
            type: 'info',
            after_open: function (p) {
                jQuery(p).data('info', record);
            }
        };
        var notify = Magsoft_Helper_Js.showPnotify(params);

        jQuery('#reminder_' + record.id).bind('click', function () {
            notify.remove();
            var url = 'index.php?module=Calendar&action=ActivityReminder&mode=postpone&record=' + record.id;
            AppConnector.request(url);
        });
    },

    /**
     * Function to trigger tooltip feature.
     */
    registerTooltipEvents: function () {
        var references = jQuery.merge(jQuery('[data-field-type="reference"] > a'), jQuery('[data-field-type="multireference"] > a'));
        var lastPopovers = [];

        // Fetching reference fields often is not a good idea on a given page.
        // The caching is done based on the URL so we can reuse.
        var CACHE_ENABLED = true; // TODO - add cache timeout support.

        function prepareAndShowTooltipView() {
            hideAllTooltipViews();

            var el = jQuery(this);
            var url = el.attr('href') ? el.attr('href') : '';
            if (url == '') {
                return;
            }

            // Rewrite URL to retrieve Tooltip view.
            url = url.replace('view=', 'xview=') + '&view=TooltipAjax';

            var cachedView = CACHE_ENABLED ? jQuery('[data-url-cached="' + url + '"]') : null;
            if (cachedView && cachedView.length) {
                showTooltip(el, cachedView.html());
            } else {
                AppConnector.request(url).then(function (data) {
                    cachedView = jQuery('<div>').css({display: 'none'}).attr('data-url-cached', url);
                    cachedView.html(data);
                    jQuery('body').append(cachedView);
                    showTooltip(el, data);
                });
            }
        }

        function get_popover_placement(el) {
            var width = window.innerWidth;
            var left_pos = jQuery(el).offset().left;
            if (width - left_pos > 400) {
                return 'right';
            }
            return 'left';
        }

        function showTooltip(el, data) {
            var the_placement = get_popover_placement(el);
            el.popover({
                //title: '', - Is derived from the Anchor Element (el).
                trigger: 'manual',
                content: data,
                //html: true,
                animation: false,
                placement: the_placement,
                template: '<div class="popover popover-tooltip"><div class="arrow"></div><div class="popover-inner"><button name="vtTooltipClose" class="close" style="color:white;opacity:1;font-weight:lighter;position:relative;top:3px;right:3px;">x</button><h3 class="popover-title"></h3><div class="popover-content"><div></div></div></div></div>'
            });
            lastPopovers.push(el.popover('show'));
            registerToolTipDestroy();
        }

        function hideAllTooltipViews() {
            // Hide all previous popover
            var lastPopover = null;
            while (lastPopover = lastPopovers.pop()) {
                lastPopover.popover('hide');
            }
        }

        references.each(function (index, el) {
            jQuery(el).hoverIntent({
                interval: 100, //was 100
                sensitivity: 7,
                timeout: 0,
                over: prepareAndShowTooltipView,
                out: hideAllTooltipViews
            });
        });

        function registerToolTipDestroy() {
            jQuery('button[name="vtTooltipClose"]').on('click', function (e) {
                var lastPopover = lastPopovers.pop();
                lastPopover.popover('hide');
                jQuery('.popover').css("display", "none", "important");
            });
        }
    },

    registerShowHideLeftPanelEvent: function () {
        jQuery('#toggleButton').click(function (e) {
            e.preventDefault();
            var leftPanel = jQuery('#leftPanel');
            var rightPanel = jQuery('#rightPanel');
            //var tButtonImage = jQuery('#tButtonImage');
            var tButtonImage = jQuery('#toggleButton');
            if (leftPanel.attr('class').indexOf(' hide') == -1) {
                //$('#leftPanel').hide('fast'); //slow animation
                var leftPanelshow = 1;
                leftPanel.addClass('hide');
                rightPanel.addClass('span12');
                //tButtonImage.removeClass('fa fa-outdent colorhide1').addClass("fa fa-indent colorhide2");
                tButtonImage.removeClass("is-active");
            } else {
                //$('#leftPanel').show('fast'); //slow animation
                var leftPanelshow = 0;
                leftPanel.removeClass('hide');
                rightPanel.removeClass('span12');
                //tButtonImage.removeClass('fa fa-indent colorhide2').addClass("fa fa-outdent colorhide1");
                tButtonImage.addClass('is-active');
            }
            var params = {
                'module': 'Users',
                'action': 'IndexAjax',
                'mode': 'toggleLeftPanel',
                'showPanel': leftPanelshow
            }
            AppConnector.request(params);
        });
    },

    registerEvents: function () {
        Magsoft_Index_Js.registerWidgetsEvents();
        Magsoft_Index_Js.loadWidgetsOnLoad();
        Magsoft_Index_Js.registerActivityReminder();
        Magsoft_Index_Js.registerPostAjaxEvents();
        Magsoft_Index_Js.changeSkin();
        Magsoft_Index_Js.registerShowHideLeftPanelEvent();
    },

    registerPostAjaxEvents: function () {
        Magsoft_Index_Js.registerTooltipEvents();
    }
}


//On Page Load
jQuery(document).ready(function () {
    Magsoft_Index_Js.registerEvents();
    app.listenPostAjaxReady(function () {
        Magsoft_Index_Js.registerPostAjaxEvents();
    });
});

// Required to get the functionality of All drop-down working.
jQuery(window).load(function () {
    jQuery("#topMenus").css({'overflow': 'visible'});
});

jQuery(document).on('change', '.btn-file :file', function () {
    var input = $(this),
        numFiles = input.get(0).files ? input.get(0).files.length : 1,
        label = input.val().replace(/([^\\]*\\)*/, '');
    input.trigger('fileselect', [numFiles, label]);
});

jQuery(document).ready(function () {
    $('.btn-file :file').on('fileselect', function (event, numFiles, label) {
        var input = $(this).parents('.input-group').find(':text'),
            puttext = numFiles > 1 ? numFiles + ' ficheiros selecionados' : label;
        if (input.length) {
            input.val(puttext);
        } else {
            if (puttext) {
                alert(puttext);
            }
        }
    });
});