{*<!--
/*********************************************************************************
  ** The contents of this file are subject to the magsoft CRM Public License Version 1.0
   * ("License"); You may not use this file except in compliance with the License
   * The Original Code is:  magsoft CRM Software
   * The Initial Developer of the Original Code is magsoft.
   * Portions created by magsoft are Copyright (C) magsoft.
   * All Rights Reserved.
  *
 ********************************************************************************/
-->*}
<div style='padding:10px 20px;'>
    {foreach from=$ACTIVITIES key=INDEX item=ACTIVITY}
        <div style='padding:5px;border-bottom:1px solid #eeeeee;'>
            <div class='pull-left'>
                {if $ACTIVITY->get('activitytype') == 'Task'}
                    <icon style="line-height: 31px; margin-right: 15px;" id="module_icon_Tasks"></icon>
                    {*<!--<image style='padding-top:4px;' src="{vimage_path('Tasks.png')}" width="20px"/>&nbsp;&nbsp;-->*}
                {else}
                    <icon style="line-height: 31px; margin-right: 15px;" id="module_icon_Calendar"></icon>
                    {*<!--<image style='padding-top:4px;' src="{vimage_path('Calendar.png')}" width="20px" />&nbsp;&nbsp;-->*}
                {/if}
            </div>
            <div>
                <div class='pull-left' style='margin-top:5px;'>
                    {assign var=PARENT_ID value=$ACTIVITY->get('parent_id')}
                    {assign var=CONTACT_ID value=$ACTIVITY->get('contact_id')}
                    <a href="{$ACTIVITY->getDetailViewUrl()}">{$ACTIVITY->get('subject')}</a>{if $PARENT_ID} {vtranslate('LBL_FOR')} {$ACTIVITY->getDisplayValue('parent_id')}{elseif $CONTACT_ID} {vtranslate('LBL_FOR')} {$ACTIVITY->getDisplayValue('contact_id')}{/if}
                </div>
                {assign var=START_DATE value=$ACTIVITY->get('date_start')}
                {assign var=START_TIME value=$ACTIVITY->get('time_start')}

                {assign var=DUE_DATE value=$ACTIVITY->get('due_date')}
                {assign var=DUE_TIME value=$ACTIVITY->get('time_end')}
                <p class='pull-right muted' style='margin-top:5px;padding-right:5px;'>
                    <small class='tooltip-left' data-tooltip='{Magsoft_Util_Helper::formatDateTimeIntoDayString("$START_DATE $START_TIME")} {vtranslate('LBL_TO')} {Magsoft_Util_Helper::formatDateTimeIntoDayString("$DUE_DATE $DUE_TIME")}' title='{Magsoft_Util_Helper::formatDateTimeIntoDayString("$START_DATE $START_TIME")} {vtranslate('LBL_TO')} {Magsoft_Util_Helper::formatDateTimeIntoDayString("$DUE_DATE $DUE_TIME")}'>
                        <i class="fa fa-history" style="cursor:default;"></i> {Magsoft_Util_Helper::formatDateDiffInStrings("$START_DATE $START_TIME")}
                    </small>
                </p>
                <div class='clearfix'></div>
            </div>
            <div class='clearfix'></div>
        </div>
        {foreachelse}
        {assign var=REQUEST_NAME value={getPurifiedSmartyParameters('name')}}
        {if $REQUEST_NAME eq 'OverdueActivities'}
            <span class="noDataMsg tooltip-top" data-tooltip="{vtranslate('LBL_NO_OVERDUE_ACTIVITIES', $MODULE_NAME)}">
				<i class="fa fa-inbox fa-5x" style="cursor:default;" title="{vtranslate('LBL_NO_OVERDUE_ACTIVITIES', $MODULE_NAME)}"></i>
				</span>
        {else}
            <span class="noDataMsg tooltip-top" data-tooltip="{vtranslate('LBL_NO_SCHEDULED_ACTIVITIES', $MODULE_NAME)}">
				<i class="fa fa-inbox fa-5x" style="cursor:default;" title="{vtranslate('LBL_NO_SCHEDULED_ACTIVITIES', $MODULE_NAME)}"></i>
				</span>
        {/if}
    {/foreach}

    {if $PAGING->get('nextPageExists') eq 'true'}
        <div class='pull-right' style='margin-top:5px;padding-right:5px;'>
            <a href="javascript:;" name="history_more" data-url="{$WIDGET->getUrl()}&page={$PAGING->getNextPage()}">{vtranslate('LBL_MORE')}
                &nbsp;<i class="fa fa-angle-double-down"></i></a>
            <br/>
            <br/>
            <br/>
            <br/>
        </div>
    {else}
        <br/>
        <br/>
        <br/>
        <br/>
    {/if}
</div>