{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
*
 ********************************************************************************/
-->*}
{strip}
    {assign var=MODULE_NAME value="Calendar"}
    <div class="summaryWidgetContainer">
        <div class="widget_header row-fluid">
            <span class="span8"><h4 class="textOverflowEllipsis">{vtranslate('LBL_ACTIVITIES',$MODULE_NAME)}</h4></span>
            <span class="span4">
			{if isPermitted('Calendar', 'CreateView') eq 'yes'}
                <button class="btn pull-right addButton createActivity" data-url="sourceModule={$RECORD->getModuleName()}&sourceRecord={$RECORD->getId()}&relationOperation=true" type="button">
					<i class="fa fa-plus"></i>
				</button>
            {/if}
 		</span>
        </div>
        <div class="widget_contents">
            {if count($ACTIVITIES) neq '0'}
            {foreach item=RECORD key=KEY from=$ACTIVITIES}
            {assign var=START_DATE value=$RECORD->get('date_start')}
            {assign var=START_TIME value=$RECORD->get('time_start')}
            {assign var=EDITVIEW_PERMITTED value=isPermitted('Calendar', 'EditView', $RECORD->get('crmid'))}
            {assign var=DETAILVIEW_PERMITTED value=isPermitted('Calendar', 'DetailView', $RECORD->get('crmid'))}
            <div class="activityEntries">
                <input type="hidden" class="activityId" value="{$RECORD->get('activityid')}"/>
                <div class="row-fluid">
                    <span class="span6"><strong title="{Magsoft_Util_Helper::formatDateTimeIntoDayString("$START_DATE $START_TIME")}">{Magsoft_Util_Helper::formatDateIntoStrings($START_DATE, $START_TIME)}</strong></span>
                    <div class="activityStatus span6">
                        {if $RECORD->get('activitytype') eq 'Task'}
                        {assign var=MODULE_NAME value=$RECORD->getModuleName()}
                        <input type="hidden" class="activityModule" value="{$RECORD->getModuleName()}"/>
                        <input type="hidden" class="activityType" value="{$RECORD->get('activitytype')}"/>
                        {if $EDITVIEW_PERMITTED == 'yes'}
                            <div class="pull-right">
                                <strong><span class="value">{vtranslate($RECORD->get('status'),$MODULE_NAME)}</span></strong>&nbsp;&nbsp;
                                <span class="editStatus cursorPointer"><i class="fa fa-pencil-square" title="{vtranslate('LBL_EDIT',$MODULE_NAME)}"></i></span>
                                <span class="edit hide">
									{assign var=FIELD_MODEL value=$RECORD->getModule()->getField('taskstatus')}
                                    {assign var=FIELD_VALUE value=$FIELD_MODEL->set('fieldvalue', $RECORD->get('status'))}
                                    {include file=vtemplate_path($FIELD_MODEL->getUITypeModel()->getTemplateName(),$MODULE_NAME) FIELD_MODEL=$FIELD_MODEL USER_MODEL=$USER_MODEL MODULE=$MODULE_NAME OCCUPY_COMPLETE_WIDTH='true'}
                                    <input type="hidden" class="fieldname" value='{$FIELD_MODEL->get('name')}' data-prev-value='{$FIELD_MODEL->get('fieldvalue')}'/>
									</span>
                            </div>
                        {/if}
                    </div>
                    {else}
                    {assign var=MODULE_NAME value="Events"}
                    <input type="hidden" class="activityModule" value="Events"/>
                    <input type="hidden" class="activityType" value="{$RECORD->get('activitytype')}"/>
                    {if $EDITVIEW_PERMITTED == 'yes'}
                        <div class="pull-right">
                            <strong><span class="value">{vtranslate($RECORD->get('eventstatus'),$MODULE_NAME)}</span></strong>&nbsp;&nbsp;
                            <span class="editStatus cursorPointer"><i class="fa fa-pencil-square" title="{vtranslate('LBL_EDIT',$MODULE_NAME)}"></i></span>
                            <span class="edit hide">
										{assign var=FIELD_MODEL value=$RECORD->getModule()->getField('eventstatus')}
                                {assign var=FIELD_VALUE value=$FIELD_MODEL->set('fieldvalue', $RECORD->get('eventstatus'))}
                                {include file=vtemplate_path($FIELD_MODEL->getUITypeModel()->getTemplateName(),$MODULE_NAME) FIELD_MODEL=$FIELD_MODEL USER_MODEL=$USER_MODEL MODULE=$MODULE_NAME OCCUPY_COMPLETE_WIDTH='true'}
                                {if $FIELD_MODEL->getFieldDataType() eq 'multipicklist'}
                                    <input type="hidden" class="fieldname" value='{$FIELD_MODEL->get('name')}[]' data-prev-value='{$FIELD_MODEL->getDisplayValue($FIELD_MODEL->get('fieldvalue'))}'/>
                                {else}
                                    <input type="hidden" class="fieldname" value='{$FIELD_MODEL->get('name')}' data-prev-value='{$FIELD_MODEL->getDisplayValue($FIELD_MODEL->get('fieldvalue'))}'/>
                                {/if}
									</span>
                        </div>
                    {/if}
                </div>
                {/if}
            </div>
            <div class="summaryViewEntries">
                {vtranslate($RECORD->get('activitytype'),$MODULE_NAME)}&nbsp;-&nbsp;
                {if $DETAILVIEW_PERMITTED == 'yes'}
                <a href="{$RECORD->getDetailViewUrl()}">{$RECORD->get('subject')}</a>{else}{$RECORD->get('subject')}{/if}&nbsp;
                {if $EDITVIEW_PERMITTED == 'yes'}<a href="{$RECORD->getEditViewUrl()}" class="fieldValue">
                    <i class="fa fa-pencil-square summaryViewEdit" title="{vtranslate('LBL_EDIT',$MODULE_NAME)}"></i>
                    </a>{/if}
            </div>
        </div>
        <hr>
        {/foreach}
        {*{else}
        <div class="summaryWidgetContainer">
            <p class="textAlignCenter">{vtranslate('LBL_NO_PENDING_ACTIVITIES',$MODULE_NAME)}</p>
        </div>*}
        {/if}
        {if $PAGING_MODEL->isNextPageExists()}
            <div class="row-fluid">
                <div class="pull-right">
                    <a href="javascript:void(0)" class="moreRecentActivities">{vtranslate('LBL_MORE',$MODULE_NAME)}</a>
                </div>
            </div>
        {/if}
    </div>
    </div>
{/strip}