{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    {* Change to this also refer: AddCommentForm.tpl *}
    {assign var="COMMENT_TEXTAREA_DEFAULT_ROWS" value="2"}
    {assign var="PRIVATE_COMMENT_MODULES" value=Magsoft_Functions::getPrivateCommentModules()}
    {assign var=CREATE_PERMISSION value=$COMMENTS_MODULE_MODEL->isPermitted('CreateView')}
    {assign var=EDIT_PERMISSION value=$COMMENTS_MODULE_MODEL->isPermitted('EditView')}
    <div class="commentContainer recentComments">
    <div class="commentTitle row-fluid">
        {if $CREATE_PERMISSION}
            <div class="addCommentBlock">
                <div>
                    <textarea name="commentcontent" class="commentcontent" placeholder="{vtranslate('LBL_ADD_YOUR_COMMENT_HERE', $MODULE_NAME)}" rows="{$COMMENT_TEXTAREA_DEFAULT_ROWS}"></textarea>
                </div>
                	{if in_array($MODULE_NAME, $PRIVATE_COMMENT_MODULES)}
                		<div class="pretty p-default p-smooth">
                			<input type="checkbox" id="is_private" checked>
                			<div class="state p-primary">
                				<label>{vtranslate('LBL_INTERNAL_COMMENT')}</label>
                			</div>
                		</div>
					{/if}
                <div class="pull-right">
                    <button class="btn btn-success detailViewSaveComment marginRightZero" type="button" data-mode="add">
                        <strong>{vtranslate('LBL_POST', $MODULE_NAME)}</strong>
                    </button>
                </div>
            </div>
        {/if}
    </div>
    <hr>
    <br>
    <div class="commentsBody">
        {if !empty($COMMENTS)}
            {foreach key=index item=COMMENT from=$COMMENTS}
                <div class="commentDetails" {if $COMMENT->get('is_private')}style="background: #fff9ea;"{/if}>
                    <div>
                        <div class="singleComment">
                        	<input type="hidden" name='is_private' value="{$COMMENT->get('is_private')}">
                            <div class="commentInfoHeader row-fluid" style="border-bottom: 1px dashed #dddddd" data-commentid="{$COMMENT->getId()}" data-parentcommentid="{$COMMENT->get('parent_comments')}">
                                <div class="commentTitle">
                                    {assign var=PARENT_COMMENT_MODEL value=$COMMENT->getParentCommentModel()}
                                    {assign var=CHILD_COMMENTS_MODEL value=$COMMENT->getChildComments()}
                                    <div class="row-fluid">
                                        <div class="span1">
                                            {assign var=IMAGE_PATH value=$COMMENT->getImagePath()}
                                            <img class="alignMiddle pull-left" src="{if !empty($IMAGE_PATH)}{$IMAGE_PATH}{else}{vimage_path('DefaultUserIcon.png')}{/if}">
                                        </div>
                                        <div class="span11 commentorInfo">
                                            {assign var=COMMENTOR value=$COMMENT->getCommentedByModel()}
                                            <div class="inner">
                                                <span class="commentorName"><strong>{$COMMENTOR->getName()}</strong></span>
                                                <span class="pull-right">
													<small class="btn-mini cancelLink" title="{Magsoft_Util_Helper::formatDateTimeIntoDayString($COMMENT->getCommentedTime())}">{Magsoft_Util_Helper::formatDateDiffInStrings($COMMENT->getCommentedTime())}</small>
												</span>
                                                <div class="clearfix"></div>
                                            </div>
                                            <div class="commentInfoContent">
                                                {nl2br($COMMENT->get('commentcontent'))}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row-fluid commentActionsContainer">
                                {assign var="REASON_TO_EDIT" value=$COMMENT->get('reasontoedit')}
                                <div class="row-fluid editStatus" name="editStatus">
										<span class="span6{if empty($REASON_TO_EDIT)} hide{/if}">
												<p class="muted">
													<small>
													[ {vtranslate('LBL_EDIT_REASON',$MODULE_NAME)} ] :
													<span name="editReason" class="textOverflowEllipsis">{nl2br($REASON_TO_EDIT)}</span>
													</small>
												</p>
										</span>
                                    {if $COMMENT->getCommentedTime() neq $COMMENT->getModifiedTime()}
                                        <span class="{if empty($REASON_TO_EDIT)}row-fluid{else} span6{/if}">
												<p class="muted pull-right">
													<small><em>{vtranslate('LBL_MODIFIED',$MODULE_NAME)}</em></small>&nbsp;
													<small title="{Magsoft_Util_Helper::formatDateTimeIntoDayString($COMMENT->getModifiedTime())}" class="commentModifiedTime">{Magsoft_Util_Helper::formatDateDiffInStrings($COMMENT->getModifiedTime())}</small>
												</p>
											</span>
                                    {/if}
                                </div>
                                <div class="row-fluid">
                                    <div class="pull-right commentActions">
										<span>
											{if $CREATE_PERMISSION}
                                                <a class="cursorPointer replyComment feedback">
													<span class="btn btn-mini">
														<i class="fa fa-commenting"></i>&nbsp;{vtranslate('LBL_REPLY',$MODULE_NAME)}
													</span>
												</a>
                                            {/if}
                                            {if $CURRENTUSER->getId() eq $COMMENT->get('userid') && $EDIT_PERMISSION}
                                                {if $CREATE_PERMISSION}&nbsp;<span>|</span>&nbsp;{/if}
                                                <a class="cursorPointer editComment feedback">
														<span class="btn btn-mini">
															<i class="fa fa-pencil"></i>&nbsp;{vtranslate('LBL_EDIT',$MODULE_NAME)}
														</span>
													</a>
                                            {/if}
 											</span>
                                        <span>
											{if $PARENT_COMMENT_MODEL neq false or $CHILD_COMMENTS_MODEL neq null}
                                                {if $CREATE_PERMISSION || $EDIT_PERMISSION}&nbsp;
                                                    <span>|</span>&nbsp;
                                                {/if}
                                                <a href="javascript:void(0);" class="cursorPointer detailViewThread">
													<span class="btn btn-mini">
														<i class="fa fa-eye"></i>&nbsp;{vtranslate('LBL_VIEW_THREAD',$MODULE_NAME)}
													</span>
												</a>
                                            {/if}
										</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            {/foreach}
        {else}
            {include file="NoComments.tpl"|@vtemplate_path}
        {/if}
    </div>
    {if $PAGING_MODEL->isNextPageExists()}
        <div class="row-fluid">
            <div class="pull-right">
                <a href="javascript:void(0)" class="moreRecentComments">{vtranslate('LBL_MORE',$MODULE_NAME)}</a>
            </div>
        </div>
    {/if}
    {if $CREATE_PERMISSION}
        <div class="hide basicAddCommentBlock">
            <div class="row-fluid">
                <div class="span12">
                    <textarea class="commentcontenthidden fullWidthAlways" name="commentcontent" rows="{$COMMENT_TEXTAREA_DEFAULT_ROWS}" placeholder="{vtranslate('LBL_ADD_YOUR_COMMENT_HERE', $MODULE_NAME)}"></textarea>
                </div>
            </div>
            	{if in_array($MODULE_NAME, $PRIVATE_COMMENT_MODULES)}
                	<div class="pretty p-default p-smooth">
                		<input type="checkbox" id="is_private" checked>
                		<div class="state p-primary">
                			<label>{vtranslate('LBL_INTERNAL_COMMENT')}</label>
                		</div>
                	</div>
				{/if}
            <div class="pull-right">
				<input type="hidden" name="is_private">
                <button class="btn btn-success detailViewSaveComment" type="button" data-mode="add">
                    <strong>{vtranslate('LBL_POST', $MODULE_NAME)}</strong></button>
                <a class="cursorPointer closeCommentBlock cancelLink" type="reset">{vtranslate('LBL_CANCEL', $MODULE_NAME)}</a>
            </div>
        </div>
        </div>
    {/if}
    {if $EDIT_PERMISSION}
        <div class="hide basicEditCommentBlock" style="min-height: 150px;">
            <div class="row-fluid">
                <div class="span12">
                    <input type="text" name="reasonToEdit" placeholder="{vtranslate('LBL_REASON_FOR_CHANGING_COMMENT', $MODULE_NAME)}" class="input-block-level"/>
                </div>
            </div>
            <div class="row-fluid">
                <div class="span12">
                    <textarea class="commentcontenthidden fullWidthAlways" name="commentcontent" rows="{$COMMENT_TEXTAREA_DEFAULT_ROWS}"></textarea>
                </div>
            </div>
            	{if in_array($MODULE_NAME, $PRIVATE_COMMENT_MODULES)}
                	<div class="pretty p-default p-smooth">
                		<input type="checkbox" id="is_private" checked>
                		<div class="state p-primary">
                			<label>{vtranslate('LBL_INTERNAL_COMMENT')}</label>
                		</div>
                	</div>
				{/if}
            <div class="pull-right">
				<input type="hidden" name="is_private">
                <button class="btn btn-success detailViewSaveComment" type="button" data-mode="edit">
                    <strong>{vtranslate('LBL_POST', $MODULE_NAME)}</strong></button>
                <a class="cursorPointer closeCommentBlock cancelLink" type="reset">{vtranslate('LBL_CANCEL', $MODULE_NAME)}</a>
            </div>
        </div>
    {/if}
    </div>
{/strip}