/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/

Magsoft_RelatedList_Js("HelpDesk_RelatedList_Js", {}, {

    registerEventToAddQuantity: function () {
        jQuery('.txt_assignqty').on('click', function (e) {
            e.stopImmediatePropagation();
        });

        jQuery('.btn_save_qnty').on('click', function (e) {
            e.stopImmediatePropagation();
            var element = jQuery(e.currentTarget);
            var relrecordid = element.data('relrecordid');
            var parentid = element.data('parentid');
            var tkt_rel_id = element.closest('td').find('.tkt_rel_id').val();
            var assign_qty = element.closest('td').find('.txt_assignqty').val();
            //if (assign_qty == '' || assign_qty == 0) {
            if (assign_qty == '') {
                //Magsoft_Helper_Js.showPnotify(app.vtranslate('JS_VALUE_SHOULD_BE_GREATER_THAN_ZERO'));
                Magsoft_Helper_Js.showPnotify(app.vtranslate('JS_VALUE_MUST_NOT_BE_EMPTY'));
            } else {
                var params = {};
                params['module'] = app.getModuleName();
                params['view'] = 'Detail';
                params['mode'] = 'deductproduct_qty';
                params['relrecordid'] = relrecordid;
                params['parentid'] = parentid;
                params['assign_qty'] = assign_qty;
                params['tkt_rel_id'] = tkt_rel_id;

                var message = app.vtranslate('JS_LBL_TQD_WILL_DEDUCT');
                Magsoft_Helper_Js.showConfirmationBox({'message': message}).then(
                    function (e) {
                        var progressInstance = jQuery.progressIndicator();
                        AppConnector.request(params).then(function (data) {
                            progressInstance.progressIndicator({'mode': 'hide'});
                            var returnedData = JSON.parse(data);
                            var sendsuccess = returnedData.result.message;
                            var finalqtd = returnedData.result.finalqtd;
                            var param = {
                                text: sendsuccess + finalqtd,
                                type: 'success',
                                icon: 'fa fa-sort-numeric-asc'
                            };
                            Magsoft_Helper_Js.showPnotify(param);
                        });
                    },
                    function (error, err) {

                    }
                );
            }
        });
    },

    registerEvents: function () {
        this.registerEventToAddQuantity();
    }
})
