/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/

jQuery.Class("Magsoft_EmailPreview_Js", {}, {

    /**
     * Function to get email actions params
     */
    getEmailActionsParams: function (mode) {
        var parentRecord = new Array();
        var parentRecordId = jQuery('[name="parentRecord"]').val();
        parentRecord.push(parentRecordId);
        var recordId = jQuery('[name="recordId"]').val();
        var params = {};
        params['module'] = "Emails";
        params['view'] = "ComposeEmail";
        params['selected_ids'] = parentRecord;
        params['record'] = recordId;
        params['mode'] = mode;
        params['parentId'] = parentRecordId;
        params['relatedLoad'] = true;

        return params;
    },

    /**
     * Function to register events for action buttons of email preview
     */
    registerEventsForActionButtons: function () {
        var thisInstance = this;
        jQuery('[name="previewReply"],[name="previewForward"],[name="previewEdit"],[name="previewPrint"]').on('click', function (e) {
            var module = "Emails";
            Magsoft_Helper_Js.checkServerConfig(module).then(function (data) {
                if (data == true) {
                    var mode = jQuery(e.currentTarget).data('mode');
                    var params = thisInstance.getEmailActionsParams(mode);
                    var urlString = (typeof params == 'string') ? params : jQuery.param(params);
                    var url = 'index.php?' + urlString;
                    self.location.href = url;
                } else {
                    var params = {
                        title: app.vtranslate('JS_EMAIL_SERVER_CONFIGURATION_TITLE'),
                        text: app.vtranslate('JS_EMAIL_SERVER_CONFIGURATION'),
                        animation: 'show',
                        icon: 'fa fa-envelope-open-o',
                        type: 'error'
                    };
                    Magsoft_Helper_Js.showPnotify(params);
                    //Magsoft_Helper_Js.showPnotify(app.vtranslate('JS_EMAIL_SERVER_CONFIGURATION'));
                }
            })
        })
    },

    registerEvents: function () {
        this.registerEventsForActionButtons();
    }
})

//On Page Load
jQuery(document).ready(function () {
    var emailPreviewInstance = new Magsoft_EmailPreview_Js();
    emailPreviewInstance.registerEvents();
    var documentHeight = (jQuery(document).height()) + 'px';
    jQuery('.SendEmailFormStep2').css('height', documentHeight);
});
