/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/
jQuery.Class("Magsoft_DigiSign_Js", {}, {
    registerFilterChangeEvent: function () {
        var thisInstance = this;
        var attachedFiles = [];
        var blockId;
        var changeedStatusOfVTUitype = false;

        /*  list of Magsoft UiTypes. "Jsign"*/
        var UiTypes = new Array();
        var UiTypesParams = {};
        UiTypesParams['module'] = 'Magsoft';
        UiTypesParams['action'] = 'VTUitype';
        UiTypesParams['mode'] = 'getVTUitype';

        AppConnector.request(UiTypesParams).then(
            function (data) {

                /* UiTypes = data.result.uitype_data; */
                UiTypes = new Array("Jsign");
                /* Enable LayoutEditor and index view */
                var activeModule = app.getModuleName(), activeView = app.getViewName();

                if (activeModule == 'LayoutEditor') {
                    jQuery('button.addCustomField').on('click', function (e) {
                        blockId = jQuery(e.currentTarget).closest('.editFieldsTable').data('blockId');

                        /** adding VTUitpes into select field picklist */
                        jQuery.each(UiTypes, function (index, uitypename) {
                            var optionExists = (jQuery("select.fieldTypesList option[value=" + uitypename + "]").length > 0);
                            if (optionExists == false) {
                                jQuery('select.fieldTypesList').append(jQuery("<option></option>").attr("value", uitypename).text(uitypename));
                            }
                        });
                    });

                    jQuery('span > select.fieldTypesList').on('change', function (e) {
                        var uitype = e.val;

                        if (jQuery.inArray(uitype, UiTypes) > -1) {
                            changeedStatusOfVTUitype = true;
                            var frm = document.getElementById('createFieldForm');
                            frm.classList.remove("createCustomFieldForm");
                            frm.id = 'idFrmUiTypeForVT';
                            document.getElementsByName("saveButton")[2].setAttribute('id', 'idBtnSaveBtnForVT');
                            document.getElementsByName("saveButton")[2].type = 'button';
                            var savBtn = document.getElementsByName("saveButton")[2].name = 'notsaveButton';
                            jQuery('#idBtnSaveBtnForVT').on('click', function (e) {
                                /* save ajax code here */
                                var fieldLabel = jQuery("#idFrmUiTypeForVT  input[name='fieldLabel']").val();
                                var params = jQuery('#idFrmUiTypeForVT').serializeFormData();
                                params['module'] = app.getModuleName();
                                params['parent'] = app.getParentModuleName();
                                params['action'] = 'VTField';
                                params['mode'] = 'add';
                                params['fieldType'] = uitype;
                                params['blockid'] = blockId;
                                params['fieldLabel'] = fieldLabel;
                                params['fieldLength'] = '';
                                params['decimal'] = '';
                                params['pickListValues'] = '';
                                params['sourceModule'] = jQuery('#selectedModuleName').val();
                                var aDeferred = jQuery.Deferred();
                                var progressIndicatorElement = jQuery.progressIndicator({
                                    'position': 'html',
                                    'blockInfo': {
                                        'enabled': true
                                    }
                                });
                                AppConnector.request(params).then(
                                    function (data) {
                                        progressIndicatorElement.progressIndicator({'mode': 'hide'});
                                        aDeferred.resolve(data);
                                        location.reload();
                                    },
                                    function (error) {
                                        progressIndicatorElement.progressIndicator({'mode': 'hide'});
                                        aDeferred.reject(error);
                                    });
                            });
                        } else {
                            if (changeedStatusOfVTUitype) {
                                changeedStatusOfVTUitype = false;
                                var frm = document.getElementById('idFrmUiTypeForVT');
                                frm.setAttribute('class', 'form-horizontal createCustomFieldForm');
                                frm.id = 'createFieldForm';
                                var savebtn = document.getElementById('idBtnSaveBtnForVT');
                                savebtn.type = 'submit';
                                savebtn.name = 'saveButton';
                                savebtn.id = '';
                            }
                        }
                    });

                } else if (activeView == 'Detail') {
                    /** inline edit remove  */
                    jQuery('span.value').each(function (e) {
                        jQuery(this).prop("id", 'idSpan_' + e);
                        if (jQuery.inArray(jQuery('#idSpan_' + e).attr('data-field-type'), UiTypes) > -1) {
                            var tdid = jQuery('#idSpan_' + e).closest('td').attr('id');
                            jQuery('#' + tdid).removeClass('fieldValue');
                        }
                    });

                }
            },
            function (error) {
                //console.log(data);
            });

        jQuery('.widget_header').on('change', 'select[name="layoutEditorModules"]', function () {
            var url = '?module=LayoutEditor&parent=Settings&view=Index&sourceModule=' + jQuery(this).val();
            window.location.href = url;
        });

    },

    registerEvents: function () {
        this.registerFilterChangeEvent();

    }
});
jQuery(document).ready(function () {
    var settingCountersInstance = new Magsoft_DigiSign_Js();
    settingCountersInstance.registerEvents();
});