{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    {assign var=SELECTED_FIELDS value=$CUSTOMVIEW_MODEL->getSelectedFields()}
    <div class="container-fluid">
        <form class="form-inline" id="CustomView" name="CustomView" method="post" action="index.php">
            <input type="hidden" name="record" id="record" value="{$RECORD_ID}"/>
            <input type="hidden" name="module" value="{$MODULE}"/>
            <input type="hidden" name="action" value="Save"/>
            <input type="hidden" name="source_module" value="{$SOURCE_MODULE}"/>
            <input type="hidden" id="stdfilterlist" name="stdfilterlist" value=""/>
            <input type="hidden" id="advfilterlist" name="advfilterlist" value=""/>
            <input type="hidden" id="status" name="status" value="{$CV_PRIVATE_VALUE}"/>
            <div class="CustomFilterViewTitle">
                <h3>{vtranslate('LBL_CREATE_VIEW',$MODULE)}</h3>
            </div>
            <hr>
            <input type="hidden" id="sourceModule" value="{$SOURCE_MODULE}">
            <input type="hidden" name="date_filters" data-value='{Magsoft_Util_Helper::toSafeHTML(ZEND_JSON::encode($DATE_FILTERS))}'/>
            <div class="filterBlocksAlignment">
                <br>
                <h4 class="filterHeaders">{vtranslate('LBL_BASIC_DETAILS',$MODULE)}:</h4>
                <br>
                <table class="table table-bordered detailview-table">
                    <tbody>
                    <tr>
                        <td class="fieldLabel wide" width="20%">
                            <label><span class="redColor">*</span> {vtranslate('LBL_VIEW_NAME',$MODULE)}</label>
                        </td>
                        <td class="fieldValue wide">
                            {if $CUSTOMVIEW_MODEL->get('viewname') eq 'All'}
                                <input type="text" id="viewname" readonly data-validation-engine='validate[required]' name="viewname" value="{$CUSTOMVIEW_MODEL->get('viewname')}">
                            {else}
                                <input type="text" id="viewname" data-validation-engine='validate[required]' name="viewname" value="{vtranslate($CUSTOMVIEW_MODEL->get('viewname'))}">
                            {/if}
                        </td>
                    </tr>
                    <tr>
                        <td class="fieldValue wide" colspan="2">
                            <label class="check-switch" style="font-size: 18px">
                                <input id="setdefault" type="checkbox" name="setdefault" value="1" {if $CUSTOMVIEW_MODEL->isDefault()} checked="checked"{/if}>
                                <span></span>
                            </label>&nbsp;&nbsp;{vtranslate('LBL_SET_AS_DEFAULT',$MODULE)}&nbsp;&nbsp;&nbsp;&nbsp;
                            <label class="check-switch" style="font-size: 18px">
                                <input id="setmetrics" name="setmetrics" type="checkbox" value="1" {if $CUSTOMVIEW_MODEL->get('setmetrics') eq '1'} checked="checked"{/if}>
                                <span></span>
                            </label>&nbsp;&nbsp;{vtranslate('LBL_LIST_IN_METRICS',$MODULE)}&nbsp;&nbsp;&nbsp;&nbsp;
                            <label class="check-switch" style="font-size: 18px">
                                <input id="status" name="status" type="checkbox" {if $CUSTOMVIEW_MODEL->isSetPublic()} value="{$CUSTOMVIEW_MODEL->get('status')}" checked="checked" {else} value="{$CV_PENDING_VALUE}" {/if}>
                                <span></span>
                            </label>&nbsp;&nbsp;{vtranslate('LBL_SET_AS_PUBLIC',$MODULE)}&nbsp;&nbsp;&nbsp;&nbsp;
                            {* filter copy *}
                            {if $RECORD_ID}
                                <label class="check-switch" style="font-size: 18px">
                                    <input id="copy" name="copy" type="checkbox" onChange="toggleCopy(this.checked);">
                                    <span></span>
                                </label>&nbsp;&nbsp;{vtranslate('LBL_SAVE_AS_COPY')}&nbsp;&nbsp;&nbsp;&nbsp;
                                <script type="text/javascript">
                                    var record = {$RECORD_ID};
                                    var filtername = "{$CUSTOMVIEW_MODEL->get('viewname')}";
                                    var namechanged = false;
                                    var nameappendix = " {vtranslate('LBL_COPY_APPENDIX')}";
                                    {literal}
                                    function toggleCopy(x) {
                                        if (x) {
                                            jQuery("#record").val("");
                                            if (jQuery("#viewname").val() == filtername) {
                                                jQuery("#viewname").val(function () {
                                                    return this.value + nameappendix;
                                                });
                                                namechanged = true;
                                            }
                                        } else {
                                            jQuery("#record").val(record);
                                            if (namechanged) {
                                                jQuery("#viewname").val(function () {
                                                    return this.value.replace(nameappendix, "");
                                                });
                                                namechanged = false;
                                            }
                                        }
                                    }
                                    {/literal}
                                </script>
                            {/if}
                            {* end optional filter copy *}
                        </td>
                    </tr>
                    </tbody>
                </table>
                <br>
                <h4 class="filterHeaders">{vtranslate('LBL_CHOOSE_COLUMNS',$MODULE)} ({vtranslate('LBL_MAX_NUMBER_FILTER_COLUMNS')}):</h4>
                <br>
                <div class="columnsSelectDiv">
                    {assign var=MANDATORY_FIELDS value=array()}
                    <select data-placeholder="{vtranslate('LBL_ADD_MORE_COLUMNS',$MODULE)}" multiple class="select2-container columnsSelect" id="viewColumnsSelect">
                        {foreach key=BLOCK_LABEL item=BLOCK_FIELDS from=$RECORD_STRUCTURE}
                            <optgroup label='{vtranslate($BLOCK_LABEL, $SOURCE_MODULE)}'>
                                {foreach key=FIELD_NAME item=FIELD_MODEL from=$BLOCK_FIELDS}
                                    {if $FIELD_MODEL->isMandatory()}
                                        {array_push($MANDATORY_FIELDS, $FIELD_MODEL->getCustomViewColumnName())}
                                    {/if}
                                    <option value="{$FIELD_MODEL->getCustomViewColumnName()}" data-field-name="{$FIELD_NAME}" {if in_array($FIELD_MODEL->getCustomViewColumnName(), $SELECTED_FIELDS)}selected{/if}>
                                        {vtranslate($FIELD_MODEL->get('label'), $SOURCE_MODULE)}
                                        {if $FIELD_MODEL->isMandatory() eq true}<span>*</span>{/if}
                                    </option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                        {*Required to include event fields for columns in calendar module advanced filter*}
                        {foreach key=BLOCK_LABEL item=BLOCK_FIELDS from=$EVENT_RECORD_STRUCTURE}
                            <optgroup label='{vtranslate($BLOCK_LABEL, 'Events')}'>
                                {foreach key=FIELD_NAME item=FIELD_MODEL from=$BLOCK_FIELDS}
                                    {if $FIELD_MODEL->isMandatory()}
                                        {array_push($MANDATORY_FIELDS, $FIELD_MODEL->getCustomViewColumnName())}
                                    {/if}
                                    <option value="{$FIELD_MODEL->getCustomViewColumnName()}" data-field-name="{$FIELD_NAME}" {if in_array($FIELD_MODEL->getCustomViewColumnName(), $SELECTED_FIELDS)}selected{/if}>
                                        {vtranslate($FIELD_MODEL->get('label'), $SOURCE_MODULE)}
                                        {if $FIELD_MODEL->isMandatory() eq true}<span>*</span>{/if}
                                    </option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                    <input type="hidden" name="columnslist" value='{ZEND_JSON::encode($SELECTED_FIELDS)}'/>
                    <input id="mandatoryFieldsList" type="hidden" value='{ZEND_JSON::encode($MANDATORY_FIELDS)}'/>
                </div>
                <br>
                <h4 class="filterHeaders">{vtranslate('LBL_CHOOSE_FILTER_CONDITIONS', $MODULE)}:</h4>
                <br>
                <div class="filterConditionsDiv">
                    <div class="row-fluid">
                    <span class="span12">
                        {include file='AdvanceFilter.tpl'|@vtemplate_path}
                    </span>
                    </div>
                </div>
            </div>
            <div class="filterActions">
                <a class="cancelLink pull-right" type="reset" onClick="window.location.reload()">{vtranslate('LBL_CANCEL', $MODULE)}</a>
                <button class="btn btn-success pull-right" id="customViewSubmit" type="submit">
                    <strong>{vtranslate('LBL_SAVE', $MODULE)}</strong></button>
            </div>
        </form>
    </div>
{/strip}