<?php
/*+**********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/
/* Performance paramters can be configured to fine tune magsoft CRM runtime */
$PERFORMANCE_CONFIG = array(

    // Enable log4php debugging only if requried
    'LOG4PHP_DEBUG' => false,

    // Should the caller information be captured in SQL Logging?
    // It adds little overhead for performance but will be useful to debug
    'SQL_LOG_INCLUDE_CALLER' => false,

    // If database default charset is UTF-8, set this to true
    // This avoids executing the SET NAMES SQL for each query!
    'DB_DEFAULT_CHARSET_UTF8' => true,

    // Turn-off default sorting in ListView, could eat up time as data grows
    'LISTVIEW_DEFAULT_SORTING' => false,

    // Compute list view record count while loading listview everytime.
    // Recommended value false
    'LISTVIEW_COMPUTE_PAGE_COUNT' => true,

    // To control the Email Notifications being sent to the Owner
    // By default it is set to true, if it is set to false, then notifications will not be sent
    'NOTIFY_OWNER_EMAILS' => true,

);
