<?php
function GetPHPLoggerConfiguration()
{

    return array(
        'rootLogger' => array(
            'level' => 'DEBUG',
            'appenders' => array('A1'),
        ),
        'SECURITY' => array(
            'level' => 'DEBUG',
            'appenders' => array('A2'),
        ),
        'INSTALL' => array(
            'level' => 'DEBUG',
            'appenders' => array('A3'),
        ),
        'MIGRATION' => array(
            'level' => 'DEBUG',
            'appenders' => array('A4'),
        ),
        'SOAP' => array(
            'level' => 'DEBUG',
            'appenders' => array('A5'),
        ),
        'PLATFORM' => array(
            'level' => 'DEBUG',
            'appenders' => array('A6'),
        ),
        'SQLTIME' => array(
            'level' => 'DEBUG',
            'appenders' => array('A7'),
        ),
        'appenders' => array(
            'A1' => array(
                'class' => 'LoggerAppenderRollingFile',
                'layout' => array(
                    'class' => 'LoggerLayoutPattern',
                    'params' => array(
                        'conversionPattern' => '%d{m/d/y H:i:s [u]} [%t] %p %c %x- %m%n%x',
                    ),

                ),
                'params' => array(
                    'file' => __DIR__ . '/logs/magsoftcrm.log',
                    'maxFileSize' => '3MB',
                    'maxBackupIndex' => 10,
                ),
            ),
            'A2' => array(
                'class' => 'LoggerAppenderRollingFile',
                'layout' => array(
                    'class' => 'LoggerLayoutPattern',
                    'params' => array(
                        'conversionPattern' => '%d{m/d/y H:i:s [u]} [%t] %p %c %x- %m%n%x',
                    ),

                ),
                'params' => array(
                    'file' => __DIR__ . '/logs/security.log',
                    'maxFileSize' => '3MB',
                    'maxBackupIndex' => 10,
                ),
            ),
            'A3' => array(
                'class' => 'LoggerAppenderRollingFile',
                'layout' => array(
                    'class' => 'LoggerLayoutPattern',
                    'params' => array(
                        'conversionPattern' => '%d{m/d/y H:i:s [u]} [%t] %p %c %x- %m%n%x',
                    ),

                ),
                'params' => array(
                    'file' => __DIR__ . '/logs/installation.log',
                    'maxFileSize' => '3MB',
                    'maxBackupIndex' => 10,
                ),
            ),
            'A4' => array(
                'class' => 'LoggerAppenderRollingFile',
                'layout' => array(
                    'class' => 'LoggerLayoutPattern',
                    'params' => array(
                        'conversionPattern' => '%d{m/d/y H:i:s [u]} [%t] %p %c %x- %m%n%x',
                    ),

                ),
                'params' => array(
                    'file' => __DIR__ . '/logs/migration.log',
                    'maxFileSize' => '3MB',
                    'maxBackupIndex' => 10,
                ),
            ),
            'A5' => array(
                'class' => 'LoggerAppenderRollingFile',
                'layout' => array(
                    'class' => 'LoggerLayoutPattern',
                    'params' => array(
                        'conversionPattern' => '%d{m/d/y H:i:s [u]} [%t] %p %c %x- %m%n%x',
                    ),

                ),
                'params' => array(
                    'file' => __DIR__ . '/logs/soap.log',
                    'maxFileSize' => '3MB',
                    'maxBackupIndex' => 10,
                ),
            ),
            'A6' => array(
                'class' => 'LoggerAppenderRollingFile',
                'layout' => array(
                    'class' => 'LoggerLayoutPattern',
                    'params' => array(
                        'conversionPattern' => '%d{m/d/y H:i:s [u]} [%t] %p %c %x- %m%n%x',
                    ),

                ),
                'params' => array(
                    'file' => __DIR__ . '/logs/platform.log',
                    'maxFileSize' => '3MB',
                    'maxBackupIndex' => 10,
                ),
            ),
            'A7' => array(
                'class' => 'LoggerAppenderRollingFile',
                'layout' => array(
                    'class' => 'LoggerLayoutPattern',
                    'params' => array(
                        'conversionPattern' => '%d{m/d/y H:i:s [u]} [%t] %p %c %x- %m%n%x',
                    ),

                ),
                'params' => array(
                    'file' => __DIR__ . '/logs/sqltime.log',
                    'maxFileSize' => '3MB',
                    'maxBackupIndex' => 10,
                ),
            ),
        ),
    );
}

function GetPHPLoggerConfiguration_Disabled()
{
    $conf = GetPHPLoggerConfiguration();
    $conf['rootLogger']['level'] = "OFF";
    $conf['SECURITY']['level'] = "OFF";
    $conf['INSTALL']['level'] = "OFF";
    $conf['MIGRATION']['level'] = "OFF";
    $conf['SOAP']['level'] = "OFF";
    $conf['PLATFORM']['level'] = "OFF";
    $conf['SQLTIME']['level'] = "OFF";
    return $conf;
}