<?php
/*+**********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Magsoft/CRMEntity.php';

class ModuleName extends Magsoft_CRMEntity
{
    var $table_name = 'magsoft_<modulename>';
    var $table_index = '<modulename>id';

    /**
     * Mandatory table for supporting related module.
     */
    var $related_tables = Array('magsoft_<modulename>cf', '<modulename>id');


    /**
     * Mandatory table for supporting custom fields.
     */
    var $customFieldTable = Array('magsoft_<modulename>cf', '<modulename>id');

    /**
     * Mandatory for Saving, Include tables related to this module.
     */
    var $tab_name = Array('magsoft_crmentity', 'magsoft_<modulename>', 'magsoft_<modulename>cf');

    /**
     * Mandatory for Saving, Include tablename and tablekey columnname here.
     */
    var $tab_name_index = Array(
        'magsoft_crmentity' => 'crmid',
        'magsoft_<modulename>' => '<modulename>id',
        'magsoft_<modulename>cf' => '<modulename>id');

    /**
     * Mandatory for Listing (Related listview)
     */
    var $list_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        // tablename should not have prefix 'magsoft_'
        '<entityfieldlabel>' => Array('<modulename>', '<entitycolumn>'),
        'Assigned To' => Array('crmentity', 'smownerid')
    );
    var $list_fields_name = Array(
        /* Format: Field Label => fieldname */
        '<entityfieldlabel>' => '<entityfieldname>',
        'Assigned To' => 'assigned_user_id',
    );

    // Make the field link to detail view
    var $list_link_field = '<entityfieldname>';

    // For Popup listview and UI type support
    var $search_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        // tablename should not have prefix 'magsoft_'
        '<entityfieldlabel>' => Array('<modulename>', '<entitycolumn>'),
        'Assigned To' => Array('magsoft_crmentity', 'assigned_user_id'),
    );
    var $search_fields_name = Array(
        /* Format: Field Label => fieldname */
        '<entityfieldlabel>' => '<entityfieldname>',
        'Assigned To' => 'assigned_user_id',
    );

    // For Popup window record selection
    var $popup_fields = Array('<entityfieldname>');

    // For Alphabetical search
    var $def_basicsearch_col = '<entityfieldname>';

    // Column value to use on detail view record text display
    var $def_detailview_recname = '<entityfieldname>';

    // Used when enabling/disabling the mandatory fields for the module.
    // Refers to magsoft_field.fieldname values.
    var $mandatory_fields = Array('<entityfieldname>', 'assigned_user_id');

    var $default_order_by = '<entityfieldname>';
    var $default_sort_order = 'ASC';

    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type
     */
    function vtlib_handler($moduleName, $eventType)
    {
        global $adb;
        if ($eventType == 'module.postinstall') {
            // TODO Handle actions after this module is installed.
        } else if ($eventType == 'module.disabled') {
            // TODO Handle actions before this module is being uninstalled.
        } else if ($eventType == 'module.preuninstall') {
            // TODO Handle actions when this module is about to be deleted.
        } else if ($eventType == 'module.preupdate') {
            // TODO Handle actions before this module is updated.
        } else if ($eventType == 'module.postupdate') {
            // TODO Handle actions after this module is updated.
        }
    }
}