<?php
/* * *******************************************************************************
 * The content of this file is subject to the Magsoft Customer Portal license.
 * ("License"); You may not use this file except in compliance with the License
 * All Rights Reserved.
 * ****************************************************************************** */
?>
<div id="page-wrapper">
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header"><?php echo Language::translate($module); ?> </h1>
        </div>
        <!-- /.col-lg-12 -->
    </div>
    <?php
    if (isset($data['plugin_data']['views']['header'])) {
        foreach ($data['plugin_data']['views']['header'] as $pluginname => $viewname) {
            Template::displayPlugin($pluginname, $data, $viewname);
        }
    }
    ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <?php echo Language::translate($module); ?>
                </div>
                <!-- /.panel-heading -->
                <div class="panel-body">
                    <?php if (isset($data['recordlist']) && count($data['recordlist']) > 0) { ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                <thead>
                                <tr>
                                    <?php foreach ($data['tableheader'] as $hf) echo "<th>" . Language::translate($hf['fielddata']) . "</th>"; ?>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($data['recordlist'] as $record) {

                                    echo "<tr>";
                                    foreach ($record as $record_fields) echo "<td>" . Language::translate($record_fields['fielddata']) . "</td>";
                                    echo "</tr>";

                                }

                                ?>
                                </tbody>
                            </table>
                            <div class="panel-footer-table">
                                <div class="row">
                                    <div id="footer-left" class="col-sm-6 pull-left">
                                    </div>
                                    <div id="footer-right" class="col-sm-6 pull-right">
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                        <h2><?php echo Language::translate("No " . $module . " records Found!"); ?></h2>
                        <br>
                    <?php } ?>
                </div>
                <!-- /.panel-body -->
            </div>
            <!-- /.panel -->
        </div>
        <!-- /.col-lg-12 -->
    </div>
    <!-- /.row -->
    <?php
    if (isset($data['plugin_data']['views']['footer'])) {
        foreach ($data['plugin_data']['views']['footer'] as $pluginname => $viewname) {
            Template::displayPlugin($pluginname, $data, $viewname);
        }
    }
    ?>
</div>
<!-- /#page-wrapper -->
<script>
    $(document).ready(function () {
        $('#dataTables-example').dataTable({
            //"iDisplayLength": 50,
            //"oSearch": {"sSearch": "Aberto"}
            //"orderFixed": [ 4, 'asc' ]
            "language": {
                "lengthMenu": "_MENU_",
                "search": "",
                "searchPlaceholder": "Pesquisar ...",
                "zeroRecords": "Sem resultados encontrados",
                "info": "Página _PAGE_ de _PAGES_",
                "infoEmpty": "Sem resultados",
                "infoFiltered": "(total: _MAX_)",
                "paginate": {
                    "first": "Primeira",
                    "last": "Última",
                    "next": "Seguinte",
                    "previous": "Anterior"
                }
            }
        });
        $("#dataTables-example_info").detach().appendTo('#footer-left');
        $("#dataTables-example_paginate").detach().appendTo('#footer-right');
        $("tfoot").detach().appendTo('#dataTables-example_filter');
    });
</script>
<!--<script>
    $(document).ready(function () {
        $('#dataTables-example').dataTable({
            //"iDisplayLength": 50
        });
        $("#dataTables-example_info").detach().appendTo('#footer-left');
        $("#dataTables-example_paginate").detach().appendTo('#footer-right');
    });
</script>