<?php
/* * *******************************************************************************
 * The content of this file is subject to the Magsoft Customer Portal license.
 * ("License"); You may not use this file except in compliance with the License
 * All Rights Reserved.
 * ****************************************************************************** */
?>
<div id="page-wrapper">
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header"><?php echo Language::translate("New Ticket"); ?></h1>
        </div>
        <!-- /.col-lg-12 -->
    </div>
    <?php
    if (isset($data['plugin_data']['views']['header'])) {
        foreach ($data['plugin_data']['views']['header'] as $pluginname => $viewname) {
            Template::displayPlugin($pluginname, $data, $viewname);
        }
    }
    ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <?php echo Language::translate("Ticket Detail"); ?>
                </div>
                <form method="POST" action="index.php" role="form">
                    <!-- /.panel-heading -->
                    <div class="panel-body">
                        <input type="hidden" name="module" value="HelpDesk">
                        <input type="hidden" name="action" value="new">
                        <input type="hidden" name="projectid" value="<?php echo $_REQUEST['projectid'] ?>"/>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="title"><?php echo Language::translate("Title"); ?> *</label>
                                    <input type="text" class="form-control" id="title" name="title" placeholder="<?php echo Language::translate("Enter the title of the ticket"); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <hr>
                            </div>
                            <div class="col-md-6">
                                <!-- <div class="form-group">
                                    <label for="category"><?php echo Language::translate("Category"); ?></label>
                                    <select class="form-control" name="category" id="category">
                                        <option value="" selected=""><?php echo Language::translate("Select an Option"); ?></option>
                                        <?php
                                foreach ($data['picklists']['ticketcategories'] as $count => $pid) {
                                    echo '<option value="' . $pid . '">' . Language::translate($pid) . '</option>';
                                }
                                ?>
                                    </select>
                                </div>-->
                                <div class="form-group">
                                    <label for="equipamento"><?php echo Language::translate("Equipamento"); ?></label>
                                    <select class="form-control" name="equipamento" id="equipamento">
                                        <option value="" selected=""><?php echo Language::translate("Select an Option"); ?></option>
                                        <?php
                                        foreach ($data['picklists']['equipamento_id'] as $count => $pid) {
                                            echo '<option value="' . $pid . '">' . Language::translate($pid) . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="marca"><?php echo Language::translate("Brand"); ?></label>
                                    <select class="form-control" name="marca" id="marca">
                                        <option value="" selected=""><?php echo Language::translate("Select an Option"); ?></option>
                                        <?php
                                        foreach ($data['picklists']['marca_id'] as $count => $pid) {
                                            echo '<option value="' . $pid . '">' . Language::translate($pid) . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="modelo"><?php echo Language::translate("Model"); ?></label>
                                    <input type="text" class="form-control" id="modelo" name="modelo" placeholder="<?php echo Language::translate("Enter model"); ?>">
                                </div>
                                <div class="form-group">
                                    <label for="priority"><?php echo Language::translate("Priority"); ?></label>
                                    <select class="form-control" name="priority" id="priority">
                                        <option value="" selected=""><?php echo Language::translate("Select an Option"); ?></option>
                                        <?php
                                        foreach ($data['picklists']['ticketpriorities'] as $count => $pid) {
                                            echo '<option value="' . $pid . '">' . Language::translate($pid) . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="serialnumber"><?php echo Language::translate("Serial Number"); ?></label>
                                    <input type="text" class="form-control" id="serialnumber" name="serialnumber" placeholder="<?php echo Language::translate("Enter serial number"); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <hr>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="productid"><?php echo Language::translate("Related Product"); ?></label>
                                    <select class="form-control" name="productidf" id="productid">
                                        <option value="" selected=""><?php echo Language::translate("Select an Option"); ?></option>
                                        <?php
                                        foreach ($data['picklists']['productid'] as $count => $pid) {
                                            echo '<option value="' . $pid . '">' . Language::translate($data['picklists']['productname'][$count]) . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="serviceid"><?php echo Language::translate("Contract Service"); ?></label>
                                    <select class="form-control" name="serviceid" id="serviceid">
                                        <option value="" selected=""><?php echo Language::translate("Select an Option"); ?></option>
                                        <?php
                                        if (isset($data['picklists']['serviceid']) && isset($data['picklists']['serviceid'])) foreach ($data['picklists']['serviceid'] as $count => $pid) {
                                            echo '<option value="' . $pid . '">' . Language::translate($data['picklists']['servicename'][$count]) . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <hr>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description"><?php echo Language::translate("Description"); ?></label>
                                    <textarea name="description" id="description" class="form-control" rows="6"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.panel-body -->
                    <div class="panel-footer">
                        <input type="submit" value="<?php echo Language::translate("Submit Ticket"); ?>" class="btn btn-success btn-md">
                    </div>
                </form>
                <!-- /.panel-footer -->
            </div>
        </div>
        <!-- /.col-lg-6 -->
    </div>
    <!-- /.row -->
    <?php
    if (isset($data['plugin_data']['views']['footer'])) {
        foreach ($data['plugin_data']['views']['footer'] as $pluginname => $viewname) {
            Template::displayPlugin($pluginname, $data, $viewname);
        }
    }
    ?>
</div>
<!-- /#page-wrapper -->
<script>
    $(document).ready(function () {
        $('#dataTables-example').dataTable();
    });
</script>
