<?php
/*+*******************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ******************************************************************************/
require_once 'include/events/SqlResultIterator.inc';

class VTExpressionsManager
{
    function __construct($adb)
    {
        $this->adb = $adb;
    }

    /** Caching logic **/
    private static $cache = array();

    static function addToCache($key, $value)
    {
        self::$cache[$key] = $value;
    }

    static function fromCache($key)
    {
        if (isset(self::$cache[$key])) {
            return self::$cache[$key];
        }
        return false;
    }

    static function clearCache()
    {
        self::$cache = array();
    }

    /** END **/

    function fields($moduleName)
    {
        global $current_user;
        $result = vtws_describe($moduleName, $current_user);
        $fields = $result['fields'];
        $arr = array();
        foreach ($fields as $field) {
            $arr[$field['name']] = $field['label'];
        }
        return $arr;
    }

    function expressionFunctions()
    {
        return array('concat' => 'concat(a,b)', 'time_diffdays(a,b)' => 'time_diffdays(a,b)', 'time_diffdays(a)' => 'time_diffdays(a)', 'time_diff(a,b)' => 'time_diff(a,b)', 'time_diff(a)' => 'time_diff(a)',
            'add_days' => 'add_days(datefield, noofdays)', 'sub_days' => 'sub_days(datefield, noofdays)', 'add_time(timefield, minutes)' => 'add_time(timefield, minutes)', 'sub_time(timefield, minutes)' => 'sub_time(timefield, minutes)',
            'today' => "get_date('today')", 'tomorrow' => "get_date('tomorrow')", 'yesterday' => "get_date('yesterday')");
    }
}
