jQuery.Class('DiscountConfigForm_Js', {}, {
    getForm: function () {
        return jQuery('#timesheetstop');
    },
    openPopUp: function (e) {
        var parentElem = jQuery(e.target).closest('td');

        var params = {};
        var params = {
            'module': 'TimeSheet',
            'src_module': app.getModuleName(),
            'src_field': 'timesheet_id',
            'src_record': app.getRecordId(),
            'src_record_id': app.getRecordId(),
        }

        var sourceFieldElement = jQuery('input[class="sourceField"]', parentElem);

        var prePopupOpenEvent = jQuery.Event(Magsoft_Edit_Js.preReferencePopUpOpenEvent);
        sourceFieldElement.trigger(prePopupOpenEvent);

        if (prePopupOpenEvent.isDefaultPrevented()) {
            return;
        }

        var popupInstance = Magsoft_Popup_Js.getInstance();
        popupInstance.show(params, function (data) {
            var responseData = JSON.parse(data);
            var dataList = new Array();
            for (var id in responseData) {
                var data = {
                    'name': responseData[id].name,
                    'id': id
                }
                dataList.push(data);
            }

            $('#timesheet_id_display').val(data.name);
            $('#timesheet_id').val(data.id);
            $('#timesheet_id_display').prop('readonly', 'true');
        });
    },
    referenceModulePopupRegisterEvent: function (magsoftEditInstance) {
        var thisInstance = this;
        $('body').on('click', '.relatedPopup', function (e) {
            thisInstance.openPopUp(e);
        });
        $('body').find('.referenceModulesList').chosen().change(function (e) {
            var element = jQuery(e.currentTarget);
            var closestTD = element.closest('td').next();
            var popupReferenceModule = element.val();
            var referenceModuleElement = jQuery('input[name="popupReferenceModule"]', closestTD);
            var prevSelectedReferenceModule = referenceModuleElement.val();
            referenceModuleElement.val(popupReferenceModule);

            //If Reference module is changed then we should clear the previous value
            if (prevSelectedReferenceModule != popupReferenceModule) {
                closestTD.find('.clearReferenceSelection').trigger('click');
            }
        });
    },

    registerClearReferenceSelectionEvent: function () {
        $('body').on('click', '.clearReferenceSelection', function (e) {

            $('#timesheet_id_display').removeAttr('readonly').val('');
            $('#timesheet_id_display').val("");
            $('#timesheet_id').val("");

            var element = jQuery(e.currentTarget);
            element.trigger(Magsoft_Edit_Js.referenceDeSelectionEvent);
            e.preventDefault();
        })
    },

    setReferenceFieldValue: function (params) {
        var fieldElement = $('input[name="timesheet_id"]');
        var fieldDisplayElement = $('input[name="timesheet_id_display"]');
        var popupReferenceModule = $('input[name="popupReferenceModule"]').val();

        var selectedName = params.name;
        var id = params.id;

        $("#timesheet_id").val(id);
        $('input[name="timesheet_id_display"]').val(selectedName).attr('readonly', true);
        fieldElement.trigger(Magsoft_Edit_Js.referenceSelectionEvent, {
            'source_module': popupReferenceModule,
            'record': id,
            'selectedName': selectedName
        });
    },

    /**
     * Function which will handle the reference auto complete event registrations
     * @params - container <jQuery> - element in which auto complete fields needs to be searched
     */

    registerAutoCompleteFields: function (magsoftEditInstance) {
        var thisInstance = this;
        var container = thisInstance.getForm();

        container.find('input.autoComplete').autocomplete({
            'minLength': '3',
            'source': function (request, response) {
                //element will be array of dom elements
                //here this refers to auto complete instance
                var inputElement = jQuery(this.element[0]);
                var searchValue = request.term;
                // var params = thisInstance.getReferenceSearchParams(inputElement);
                var params = {};
                params.search_module = 'TimeSheet';
                params.module = app.getModuleName();
                params.search_value = searchValue;
                params.src_record_id = app.getRecordId();

                console.log(params);
                magsoftEditInstance.searchModuleNames(params).then(function (data) {
                    var reponseDataList = new Array();
                    var serverDataFormat = data.result
                    if (serverDataFormat.length <= 0) {
                        jQuery(inputElement).val('');
                        serverDataFormat = new Array({
                            'label': app.vtranslate('JS_NO_RESULTS_FOUND'),
                            'type': 'no results'
                        });
                    }
                    for (var id in serverDataFormat) {
                        var responseData = serverDataFormat[id];
                        reponseDataList.push(responseData);
                    }
                    response(reponseDataList);
                });
            },
            'select': function (event, ui) {
                var selectedItemData = ui.item;
                //To stop selection if no results is selected
                if (typeof selectedItemData.type != 'undefined' && selectedItemData.type == "no results") {
                    return false;
                }
                selectedItemData.name = selectedItemData.value;
                thisInstance.setReferenceFieldValue(selectedItemData);
                var fieldElement = $('input[name="timesheet_id"]');

                fieldElement.trigger(Magsoft_Edit_Js.postReferenceSelectionEvent, {'data': selectedItemData});
            },
            'change': function (event, ui) {
                var element = jQuery(this);
                //if you dont have readonly attribute means the user didnt select the item
                if (element.attr('readonly') == undefined) {
                    $('.clearReferenceSelection').trigger('click');
                }
            },
            'open': function (event, ui) {
                //To Make the menu come up in the case of quick create
                jQuery(this).data('autocomplete').menu.element.css('z-index', '100001');

            }
        });

    },

    registerEvents: function () {
        var magsoftEditInstance = new Magsoft_Edit_Js();
        //var container = this.getForm();
        this.referenceModulePopupRegisterEvent(magsoftEditInstance);
        this.registerClearReferenceSelectionEvent(magsoftEditInstance);
        this.registerAutoCompleteFields(magsoftEditInstance);
    }
});

jQuery(document).ready(function () {
    var instance = new DiscountConfigForm_Js();
    instance.registerEvents();
});

$('body').on('focus', '#timesheet_id_display', function () {
    var instance = new DiscountConfigForm_Js();
    instance.registerEvents();
});
