/************************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/

ResetPortalPassword_Detail_Js = {

    ResetPassword: function (record) {

        var message;
        var action_url = 'index.php?module=ResetPortalPassword&action=ResetPassword&record=' + record;

        AppConnector.request(action_url + '&mode=control').then(function (data) {
            if (data.result.success == true) {
                message = data.result.message;

                Magsoft_Helper_Js.showConfirmationBox({'message': message}).then(function (data) {

                        AppConnector.request(action_url).then(function (data) {

                            if (data.success == true) {

                                if (data.result.success == true) {
                                    var message_type = "success";
                                } else {
                                    var message_type = "error";
                                }

                                var params = {
                                    text: data.result.message,
                                    type: message_type,
                                    icon: 'fa fa-envelope-open-o'
                                };

                                Magsoft_Helper_Js.showMessage(params);
                            }
                        });
                    },
                    function (error, err) {
                    });

            } else {
                if (data.result.message == 0) {
                    data.result.message = app.vtranslate('JS_EMAIL_SERVER_CONFIGURATION');
                }
                var params = {
                    text: data.result.message,
                    type: "error",
                    icon: 'fa fa-envelope-open-o'
                };
                Magsoft_Helper_Js.showMessage(params);
            }
        });


    },
};
