<?php
/*+**********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'includes/runtime/Viewer.php';

class Mobile_UI_Viewer extends Magsoft_Viewer
{

    private $parameters = array();

    function assign($key, $value)
    {
        $this->parameters[$key] = $value;
    }

    function viewController()
    {
        $smarty = new Magsoft_Viewer();

        foreach ($this->parameters as $k => $v) {
            $smarty->assign($k, $v);
        }

        $smarty->assign("IS_SAFARI", Mobile::isSafari());
        $smarty->assign("SKIN", Mobile::config('Default.Skin'));
        return $smarty;
    }

    function process($templateName)
    {
        $smarty = $this->viewController();
        $response = new Mobile_API_Response();
        $response->setResult($smarty->fetch(vtlib_getModuleTemplate('Mobile', $templateName)));
        return $response;
    }

}