<?php
/*+**********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/
include_once dirname(__FILE__) . '/../Alert.php';

class Mobile_WS_AlertModel_Projects extends Mobile_WS_AlertModel
{
    function __construct()
    {
        parent::__construct();
        $this->name = 'My Projects';
        $this->moduleName = 'Project';
        $this->refreshRate = 1 * (24 * 60 * 60); // 1 day
        $this->description = 'Projects Related To Me';
    }

    function query()
    {
        $sql = "SELECT crmid FROM magsoft_crmentity INNER JOIN magsoft_project ON
                    magsoft_project.projectid=magsoft_crmentity.crmid WHERE magsoft_crmentity.deleted=0 AND magsoft_crmentity.smownerid=? AND
                    magsoft_project.projectstatus <> 'completed'";
        return $sql;
    }

    function queryParameters()
    {
        return array($this->getUser()->id);
    }

}

