<?php
/*+**********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/
include_once dirname(__FILE__) . '/../Alert.php';

/** Events for today alert */
class Mobile_WS_AlertModel_EventsOfMineToday extends Mobile_WS_AlertModel
{
    function __construct()
    {
        parent::__construct();
        $this->name = 'Your events for the day';
        $this->moduleName = 'Calendar';
        $this->refreshRate = 1 * (24 * 60 * 60); // 1 day
        $this->description = 'Alert sent when events are scheduled for the day';
    }

    function query()
    {
        $today = date('Y-m-d');
        $sql = "SELECT crmid, activitytype FROM magsoft_activity INNER JOIN 
				magsoft_crmentity ON magsoft_crmentity.crmid=magsoft_activity.activityid
				WHERE magsoft_crmentity.deleted=0 AND magsoft_crmentity.smownerid=? AND 
				magsoft_activity.activitytype <> 'Emails' AND 
				(magsoft_activity.date_start = '{$today}' OR magsoft_activity.due_date = '{$today}')";
        return $sql;
    }

    function queryParameters()
    {
        return array($this->getUser()->id);
    }
}
