<?php

/*+**********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 ************************************************************************************/

class Mobile_WS_FetchModuleFilters extends Mobile_WS_Controller
{

    function process(Mobile_API_Request $request)
    {
        $response = new Mobile_API_Response();

        $module = $request->get('module');
        $current_user = $this->getActiveUser();

        $result = array();

        $filters = $this->getModuleFilters($module, $current_user);
        $yours = array();
        $others = array();
        if (!empty($filters)) {
            foreach ($filters as $filter) {
                if ($filter['userName'] == $current_user->column_fields['user_name']) {
                    $yours[] = $filter;
                } else {
                    $others[] = $filter;
                }
            }
        }

        $result['filters'] = array('yours' => $yours, 'others' => $others);
        $response->setResult($result);

        return $response;
    }

    protected function getModuleFilters($moduleName, $user)
    {

        $filters = array();

        global $adb;
        $sql = "SELECT magsoft_customview.*, magsoft_users.user_name FROM magsoft_customview 
			INNER JOIN magsoft_users ON magsoft_customview.userid = magsoft_users.id WHERE magsoft_customview.entitytype=?";
        $parameters = array($moduleName);

        if (!is_admin($user)) {
            require('user_privileges/user_privileges_' . $user->id . '.php');

            $sql .= " AND (magsoft_customview.status=0 or magsoft_customview.userid = ? or magsoft_customview.status = 3 or magsoft_customview.userid IN
			(SELECT magsoft_user2role.userid FROM magsoft_user2role INNER JOIN magsoft_users on magsoft_users.id=magsoft_user2role.userid 
			INNER JOIN magsoft_role on magsoft_role.roleid=magsoft_user2role.roleid WHERE magsoft_role.parentrole LIKE '" . $current_user_parent_role_seq . "::%'))";

            array_push($parameters, $current_user->id);
        }

        $result = $adb->pquery($sql, $parameters);
        if ($result && $adb->num_rows($result)) {
            while ($resultrow = $adb->fetch_array($result)) {
                $filters[] = $this->prepareFilterDetailUsingResultRow($resultrow);
            }
        }

        return $filters;
    }

    protected function prepareFilterDetailUsingResultRow($resultrow)
    {
        $filter = array();
        $filter['cvid'] = $resultrow['cvid'];
        $filter['viewname'] = decode_html($resultrow['viewname']);
        $filter['setdefault'] = $resultrow['setdefault'];
        $filter['setmetrics'] = $resultrow['setmetrics'];
        $filter['moduleName'] = decode_html($resultrow['entitytype']);
        $filter['status'] = decode_html($resultrow['status']);
        $filter['userName'] = decode_html($resultrow['user_name']);
        return $filter;
    }
}