/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/

Settings_Workflows_Edit_Js.prototype.preSaveWfCalculateTask = function (tasktype) {
    var values = this.getWfCalculateValues(tasktype);
    jQuery('[name="field_value_mapping"]').val(JSON.stringify(values));
};

Settings_Workflows_Edit_Js.prototype.getWfCalculateTaskFieldList = function () {
    return new Array('target_field', 'source_field', 'method_field');
};
Settings_Workflows_Edit_Js.prototype.getWfCalculateValues = function (tasktype) {
    var thisInstance = this;
    var conditionsContainer = jQuery('#save_fieldvaluemapping');
    var fieldListFunctionName = 'get' + tasktype + 'FieldList';
    if (typeof thisInstance[fieldListFunctionName] != 'undefined') {
        var fieldList = thisInstance[fieldListFunctionName].apply()
    }

    var values = [];
    var conditions = jQuery('.mappingRow', conditionsContainer);
    conditions.each(function (i, conditionDomElement) {
        var rowElement = jQuery(conditionDomElement);
        var targetFieldElement = jQuery('[name="target_field"]', rowElement);
        var sourceFieldElement = jQuery('[name="source_field"]', rowElement);
        var methodElement = jQuery('[name="method_field"]', rowElement);

        //To not send empty fields to server
        if (thisInstance.isEmptyFieldSelected(targetFieldElement)) {
            return true;
        }
        if (thisInstance.isEmptyFieldSelected(sourceFieldElement)) {
            return true;
        }
        if (thisInstance.isEmptyFieldSelected(methodElement)) {
            return true;
        }
        var rowValues = {};
        rowValues['target_field'] = targetFieldElement.find('option:selected').val();
        rowValues['source_field'] = sourceFieldElement.find('option:selected').val();
        rowValues['method_field'] = methodElement.find('option:selected').val();
        values.push(rowValues);
    });
    return values;
};

Settings_Workflows_Edit_Js.prototype.RollupWfCalculateCustomValidation = function () {
    var result = true;
    return result;
};
Settings_Workflows_Edit_Js.prototype.registerWfCalculateTaskEvents = function () {
    this.registerAddMappingButton();
    this.registerDeleteMappingEvent();
};
Settings_Workflows_Edit_Js.prototype.registerAddMappingButton = function () {
    var thisInstance = this;
    jQuery('#saveTask').on('click', '#addFieldBtn', function (e) {
        var newAddFieldContainer = jQuery('.basicAddFieldContainer').clone(true, true).removeClass('basicAddFieldContainer hide').addClass('mappingRow');
        jQuery('select', newAddFieldContainer).addClass('select2');
        jQuery('#save_fieldvaluemapping').append(newAddFieldContainer);
        //change in to chosen elements
        app.changeSelectElementView(newAddFieldContainer);
        app.showSelect2ElementView(newAddFieldContainer.find('.select2'));
    });
};
Settings_Workflows_Edit_Js.prototype.registerDeleteMappingEvent = function () {
    jQuery('#saveTask').on('click', '.deleteMappingButton', function (e) {
        jQuery(e.currentTarget).closest('.mappingRow').remove();
    })
};