/*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************/

jQuery.Class("WfCalculate_Settings_Js", {
    instance: false,
    getInstance: function () {
        if (WfCalculate_Settings_Js.instance == false) {
            var instance = new WfCalculate_Settings_Js();
            WfCalculate_Settings_Js.instance = instance;
            return instance;
        }
        return WfCalculate_Settings_Js.instance;
    }
}, {
    registerEnableModuleEvent: function () {
        jQuery('.summaryWidgetContainer').find('#enable_module').change(function (e) {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });

            var element = e.currentTarget;
            var value = 0;
            var text = "Workflow Calculate Fields Disabled";
            if (element.checked) {
                value = 1;
                text = "Workflow Calculate Fields Enabled";
            }
            var params = {};
            params.action = 'ActionAjax';
            params.module = 'WfCalculate';
            params.value = value;
            params.mode = 'enableModule';
            AppConnector.request(params).then(
                function (data) {
                    progressIndicatorElement.progressIndicator({'mode': 'hide'});
                    var params = {};
                    params['text'] = text;
                    Settings_Magsoft_Index_Js.showMessage(params);
                },
                function (error) {
                    //TODO : Handle error
                    progressIndicatorElement.progressIndicator({'mode': 'hide'});
                }
            );
        });
    },
    registerEvents: function () {
        this.registerEnableModuleEvent();
    }
});