{*<!--
/*********************************************************************************
** The contents of this file are subject to the magsoft CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  magsoft CRM Software
* The Initial Developer of the Original Code is magsoft.
* Portions created by magsoft are Copyright (C) magsoft.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    <!DOCTYPE html>
    <html>
    <head>
        <title>Magsoft</title>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
        <link rel="stylesheet" href="libraries/bootstrap/css/bootstrap.css" type="text/css" media="screen"/>
        <link rel="stylesheet" href="resources/styles.css" type="text/css" media="screen"/>
        <link rel="stylesheet" href="libraries/jquery/select2/select2.css"/>
        <link rel="stylesheet" href="libraries/jquery/posabsolute-jQuery-Validation-Engine/css/validationEngine.jquery.css"/>
        <script type="text/javascript" src="libraries/jquery/jquery.min.js"></script>
        <script type="text/javascript" src="libraries/bootstrap/js/bootstrap-tooltip.js"></script>
        <script type="text/javascript" src="libraries/jquery/select2/select2.min.js"></script>
        <script type="text/javascript" src="libraries/jquery/posabsolute-jQuery-Validation-Engine/js/jquery.validationEngine.js"></script>
        <script type="text/javascript" src="libraries/jquery/posabsolute-jQuery-Validation-Engine/js/jquery.validationEngine-en.js"></script>
        <script type="text/javascript">{literal}
            jQuery(function () {
                jQuery('select').select2({blurOnChange: true});
                jQuery('[rel="tooltip"]').tooltip();
                jQuery('form').validationEngine({
                    prettySelect: true,
                    usePrefix: 's2id_',
                    autoPositionUpdate: true,
                    promptPosition: "topLeft",
                    showOneMessage: true
                });
                jQuery('#currency_name_controls').mouseenter(function () {
                    jQuery('#currency_name_tooltip').tooltip('show');
                });
                jQuery('#currency_name_controls').mouseleave(function () {
                    jQuery('#currency_name_tooltip').tooltip('hide');
                });
            });
            {/literal}</script>
        <style type="text/css">{literal}
            body {
                background: #eeeeee url('libraries/magsoft/img/background_setup.jpg') no-repeat scroll center top;
                background-size: 150%;
                font-size: 14px;
                opacity: 0.95;
            }

            .modal-backdrop {
                opacity: 0.35;
            }

            .tooltip {
                z-index: 1055;
            }

            input, select, textarea {
                font-size: 14px;
            }

            .input-table tr td {
                padding: 5px 10px;
                height: 30px;
                text-align: left;
            }

            input, textarea {
                box-shadow: none;
                border-radius: 2px;
            }

            .select2-drop {
                border: 1px solid #ccc;
            }

            .select2-container .select2-choice {
                background-clip: padding-box;
                background-color: #fff;
                border: 1px solid #ccc;
                border-radius: 2px;
                color: #444;
                display: block;
                height: 26px;
                line-height: 26px;
                overflow: hidden;
                padding: 2px 0 4px 8px;
                position: relative;
                text-decoration: none;
                white-space: nowrap;
            }

            .select2-container .select2-choice div {
                background-color: #fff;
                border-left: 1px solid #ccc;
                border-radius: 0 2px 2px 0;
                padding-left: 2px;
                display: block;
                height: 100%;
                position: absolute;
                right: 0;
                top: 0;
                width: 18px;
            }

            .modal {
                border-radius: 2px;
                border: 0 none;
            }

            .btn-success, .btn.active, .btn:active {
                background-color: #4baed0;
                border: none;
                text-shadow: none;
                border-radius: 2px;
                padding: 6px 12px;
                box-shadow: none;
            }

            .btn-success:hover {
                background-color: #2a88a8;
                text-shadow: none;
                box-shadow: none;
            }
            {/literal}</style>
    </head>
    <body>
    <div>
        <form class="form" method="POST" action="index.php?module=Users&action=UserSetupSave">
            <input type="hidden" name="record" value="{$CURRENT_USER_MODEL->getId()}">
            <div class="modal" {if false && $IS_FIRST_USER}style="width: 700px;"{/if}> {* FirstUser information gather - paused *}
                <div class="modal-header">
                    <h3>{vtranslate('LBL_ALMOST_THERE', $MODULE)}</h3>
                </div>
                <div class="modal-body">
                    <div>
                        <div class="row-fluid">
                            <label class="control-label"><strong>{vtranslate('LBL_ALL_FIELDS_BELOW_ARE_REQUIRED', $MODULE)}</strong></label>
                            {if $IS_FIRST_USER}
                                <div class="controls" id="currency_name_controls">
                                    <select name="currency_name" id="currency_name" style="width:100%;" placeholder="{vtranslate('LBL_BASE_CURRENCY', $MODULE)}" data-errormessage="{vtranslate('LBL_CHOOSE_BASE_CURRENCY', $MODULE)}" class="validate[required]" style="width:250px;">
                                        <option value=""></option>
                                        {foreach key=header item=currency from=$CURRENCIES}
                                            <!--Open source fix to select user preferred currency during installation -->
                                            <option value="{$header}" {if $header eq $CURRENT_USER_MODEL->get('currency_name')}selected{/if}>{$header|@getTranslatedCurrencyString}({$currency.1})</option>
                                        {/foreach}
                                    </select>
                                    <!--<span rel="tooltip" title="{vtranslate('LBL_OPERATING_CURRENCY', $MODULE)}" id="currency_name_tooltip" class="fa fa-info"></span>-->
                                    <div style="padding-top:10px;"></div>
                                </div>
                            {/if}
                            <div class="controls">
                                <select name="lang_name" id="lang_name" style="width:100%;" placeholder="{vtranslate('LBL_LANGUAGE', $MODULE)}" data-errormessage="{vtranslate('LBL_CHOOSE_LANGUAGE', $MODULE)}" class="validate[required]">
                                    <option value=""></option>
                                    {foreach key=header item=language from=$LANGUAGES}
                                        <option value="{$header}" {if $header eq $CURRENT_USER_MODEL->get('language')}selected{/if}>{$language|@getTranslatedString:$MODULE}</option>
                                    {/foreach}
                                </select>
                                <div style="padding-top:10px;"></div>
                            </div>
                            <div class="controls">
                                <select name="time_zone" id="time_zone" style="width:100%;" placeholder="{vtranslate('LBL_CHOOSE_TIMEZONE', $MODULE)}" data-errormessage="{vtranslate('LBL_CHOOSE_TIMEZONE', $MODULE)}" class="validate[required]">
                                    <option value=""></option>
                                    {foreach key=header item=time_zone from=$TIME_ZONES}
                                        <option value="{$header}" {if $header eq $CURRENT_USER_MODEL->get('time_zone')}selected{/if}>{$time_zone|@getTranslatedString:$MODULE}</option>
                                    {/foreach}
                                </select>
                                <div style="padding-top:10px;"></div>
                            </div>
                            <div class="controls">
                                <select name="date_format" id="date_format" style="width:100%;" placeholder="{vtranslate('LBL_DATE_FORMAT', $MODULE)}" data-errormessage="{vtranslate('LBL_CHOOSE_DATE_FORMAT', $MODULE)}" class="validate[required]">
                                    <option value=""></option>
                                    <option value="dd-mm-yyyy" {if $CURRENT_USER_MODEL->get('date_format') eq "dd-mm-yyyy"} selected{/if}>dd-mm-yyyy</option>
                                    <option value="mm-dd-yyyy" {if $CURRENT_USER_MODEL->get('date_format') eq "mm-dd-yyyy"} selected{/if}>mm-dd-yyyy</option>
                                    <option value="yyyy-mm-dd" {if $CURRENT_USER_MODEL->get('date_format') eq "yyyy-mm-dd"} selected{/if}>yyyy-mm-dd</option>
                                </select>
                                <div style="padding-top:10px;"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">{vtranslate('LBL_GET_STARTED', $MODULE)}</button>
                </div>
            </div>
        </form>
    </div>
    </body>
    </html>
{/strip}