/**
 * Author : Manuel
 * Company : Magsoft Crm, Portugal
 * Email : geral@magsoft.pt
 */
jQuery.Class("TwilioCall_Clicktocall_Js", {
    token: false,
    from: false,
    statuscallback: false,
    dialer: false,

    openDialerPopup: function (to, record) {
        var w = 300;
        var h = 450;
        var left = (screen.width / 2) - (w / 2);
        var top = (screen.height / 2) - (h / 2);
        TwilioCall_Clicktocall_Js.dialerwindow = window.open('index.php?module=TwilioCall&view=Dialer&to=' + to + '&record=' + record, 'Twilio Dialer', 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width=' + w + ', height=' + h + ', top=' + top + ', left=' + left);
    },

    dialNumber: function (e, to, record) {
        e.preventDefault();
        e.stopPropagation();
        var evt = e ? e : window.event;
        if (evt.stopPropagation) evt.stopPropagation();
        if (evt.cancelBubble != null) evt.cancelBubble = true;

        //to=to.replace(/[^0-9]/g,"").replace(/^1/g,"");
        if (!TwilioCall_Clicktocall_Js.dialer || (TwilioCall_Clicktocall_Js.dialer.window == null)) {
            TwilioCall_Clicktocall_Js.openDialerPopup(to, record);
        } else {
            TwilioCall_Clicktocall_Js.dialer.window.document.getElementById('tocall').value = to;
            TwilioCall_Clicktocall_Js.dialer.window.document.getElementById('record').value = record;
            TwilioCall_Clicktocall_Js.dialer.focus();
        }

    },

    addDialerLink: function () {
        var recordId = '0';
        var view = app.getViewName();
        if (typeof (view) != 'undefined' && view != null && app.getModuleName() != 'Users') {
            if (view == 'List') {
                $('[data-field-type="phone"]').each(function () {
                    if ($(this).text().trim() != '' && $(this).data('dialerlink') !== true) {
                        var to = $(this).text().trim();
                        var record = $(this).closest('tr').data('id');
                        var link = '<a class="modular" style="padding: 0 6px;" onclick="TwilioCall_Clicktocall_Js.dialNumber(event,\'' + to + '\',\'' + record + '\')"><i class="fa fa-microphone"></i></a>';
                        $(this).empty();
                        $(this).text(to);
                        $(this).append(link);

                    }
                });
            } else if (typeof (Magsoft_Detail_Js) != "undefined" && view == 'Detail' && $('.relatedModuleName').val() === undefined && $(this).data('dialerlink') !== true) {
                var detail = Magsoft_Detail_Js.getInstance();
                var record = detail.getRecordId();

                $('input').each(function () {
                    var data = $(this).data('fieldinfo');
                    if (data && data.type == "phone" && $(this).data('dialerlink') !== true) {
                        var ele = $(this).closest('td').find('span.value');
                        var to = ele.html().trim().replace(/\s+/g, '');
                        if (to != '') {
                            var link = '<a class="modular" style="padding: 0 6px;" onclick="TwilioCall_Clicktocall_Js.dialNumber(event,\'' + to + '\',\'' + record + '\')"><i class="fa fa-microphone"></i></a>';
                            $(ele).parent().append(link);
                            $(this).data('dialerlink', true);
                        }
                    }
                });
            }
        }
    },


    //add twilio icon next to phone type fields
    addCallLink: function () {
        var recordId = '0';
        if ($('#view').length) {
            if ($('#view').val() == 'List') {
                $('[data-field-type="phone"]').each(function () {
                    if ($(this).text().trim() != '') {
                        var to = $(this).text().trim();
                        var link = '<a class="modular" style="padding: 0 6px;" onclick="TwilioCall_Clicktocall_Js.makeCall(event,\'' + to + '\',' + recordId + ')"><i class="fa fa-microphone"></i></a>';
                    }
                });
            } else {
                $('[data-field-type="phone"]').each(function () {
                    if ($(this).html().trim() != '') {
                        var to = $(this).html().trim();
                        var link = '<a class="modular" style="padding: 0 6px;" onclick="TwilioCall_Clicktocall_Js.makeCall(event,\'' + to + '\',' + recordId + ')"><i class="fa fa-microphone"></i></a>';
                    }
                });
            }
        }

    },

    //get Capability token and user twilio call no.
    getToken: function () {
        var params = {
            'module': 'TwilioCall',
            'action': 'GetToken'
        }
        AppConnector.request(params).then(
            function (data) {
                if (data.result.success) {
                    TwilioCall_Clicktocall_Js.token = data.result.token;
                    TwilioCall_Clicktocall_Js.from = data.result.from;
                    TwilioCall_Clicktocall_Js.statuscallback = data.result.statuscallback;
                }
            }
        )
    },

    //setup the twilio client
    initDevice: function () {
        Twilio.Device.setup(TwilioCall_Clicktocall_Js.token);
        Twilio.Device.ready(function (device) {
            Magsoft_Helper_Js.showPnotify(app.vtranslate('Ready to make call'));
        });
        Twilio.Device.error(function (error) {
            Magsoft_Helper_Js.showPnotify(error.message);
        });
        Twilio.Device.connect(function (conn) {
            Magsoft_Helper_Js.showPnotify(app.vtranslate('Call established'));
        });
        Twilio.Device.disconnect(function (conn) {
            Magsoft_Helper_Js.showPnotify(app.vtranslate('Call ended'));
        });
    },

    //initiate the call
    initiateCall: function (to, recordid, recording) {
        if (!TwilioCall_Clicktocall_Js.token) {
            alert('Unable to fetch client token, please check Twilio configuration');
            return false;
        }
        if (!TwilioCall_Clicktocall_Js.from) {
            alert("User's Twilio Voice Number is not set.");
            return false;
        }
        params = {
            "to": to,
            "from": TwilioCall_Clicktocall_Js.from,
            "recordid": recordid,
            "action": TwilioCall_Clicktocall_Js.statuscallback,
            "recording": recording
        };
        Twilio.Device.connect(params);

    },

    //setup token and device		
    makeCall: function (e, to, recordid, recording) {
        e.preventDefault();
        e.stopPropagation();
        var evt = e ? e : window.event;
        if (evt.stopPropagation) evt.stopPropagation();
        if (evt.cancelBubble != null) evt.cancelBubble = true;
        var params = {
            'module': 'TwilioCall',
            'action': 'GetToken'
        }
        if (!TwilioCall_Clicktocall_Js.from && !TwilioCall_Clicktocall_Js.token) {
            AppConnector.request(params).then(
                function (data) {
                    if (data.result.success) {
                        TwilioCall_Clicktocall_Js.token = data.result.token;
                        TwilioCall_Clicktocall_Js.from = data.result.from;
                        TwilioCall_Clicktocall_Js.statuscallback = data.result.statuscallback;
                        TwilioCall_Clicktocall_Js.initDevice();
                        TwilioCall_Clicktocall_Js.initiateCall(to, recordid, recording);
                    } else {
                        alert(vtranslate('Unable to fetch Twilio Capability Token'));
                    }
                });
        } else {
            TwilioCall_Clicktocall_Js.initiateCall(to, recordid);
        }
    }
}, {});

$(document).ready(function () {
    var module = app.getModuleName();
    if (module == 'Accounts' || module == 'Contacts' || module == 'Leads') {
        TwilioCall_Clicktocall_Js.addDialerLink();
        app.listenPostAjaxReady(function () {
            TwilioCall_Clicktocall_Js.addDialerLink();
        });
    }
});
