{*+***********************************************************************************
 * The contents of this file are subject to the magsoft CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  magsoft CRM Software
 * The Initial Developer of the Original Code is magsoft.
 * Portions created by magsoft are Copyright (C) magsoft.
 * All Rights Reserved.
 *************************************************************************************}
{strip}
    <br>
    <div class="row-fluid">
        <table class="table table-bordered listViewEntriesTable">
            <thead>
            <tr class="listViewHeaders">
                <th width="10%">{vtranslate('LBL_ACTIVE',$QUALIFIED_MODULE)}</th>
                <th width="30%">{vtranslate('LBL_TASK_TYPE',$QUALIFIED_MODULE)}</th>
                <th>{vtranslate('LBL_TASK_TITLE',$QUALIFIED_MODULE)}</th>
            </tr>
            </thead>
            <tbody>
            {foreach from=$TASK_LIST item=TASK}
                <tr class="listViewEntries">
                    <td>
                        <label class="check-switch"><input type="checkbox" class="taskStatus" data-statusurl="{$TASK->getChangeStatusUrl()}" {if $TASK->isActive()} checked="" {/if} /><span></span></label>
                    </td>
                    <td>{vtranslate($TASK->getTaskType()->getLabel(),$QUALIFIED_MODULE)}</td>
                    <td>{$TASK->getName()}
                        <div class="pull-right actions">
								<span class="actionImages">
									<a class="tooltip-left" data-tooltip="{vtranslate('LBL_EDIT',$QUALIFIED_MODULE)}" data-url="{$TASK->getEditViewUrl()}">
										<i class="fa fa-pencil btn btn-default btn-mini color-edit" title="{vtranslate('LBL_EDIT',$QUALIFIED_MODULE)}"></i>
									</a>&nbsp;
									<a class="deleteTask tooltip-left" data-tooltip="{vtranslate('LBL_DELETE',$QUALIFIED_MODULE)}" data-deleteurl="{$TASK->getDeleteActionUrl()}">
										<i class="fa fa-remove btn btn-default btn-mini color-delete" title="{vtranslate('LBL_DELETE',$QUALIFIED_MODULE)}"></i>
									</a>
								</span>
                        </div>
                    </td>
                </tr>
            {/foreach}
            </tbody>
        </table>
        {if empty($TASK_LIST)}
            <table class="emptyRecordsDiv">
                <tbody>
                <tr>
                    <td>
                        {vtranslate('LBL_NO_TASKS_ADDED',$QUALIFIED_MODULE)}
                    </td>
                </tr>
                </tbody>
            </table>
        {/if}
    </div>
{/strip}