{*
Author : Manuel Pereira
Company : Magsoft Crm, Portugal
Email : geral@magsoft.pt
*}
{strip}
<div class="container-fluid" id="TwilioSettings">
   <div class="widget_header row-fluid">
      <div class="span8">
         <h3>{vtranslate('LBL_TWILIO_SETTINGS', $QUALIFIED_MODULE)}</h3>
         {vtranslate('LBL_TWILIO_SETTINGS_DESC', $QUALIFIED_MODULE)}
      </div>
      <div class="span4">
         <div class="pull-right btn-toolbar" style="margin-bottom: 0;">
            <span class="btn-group">
            <button class="btn btn-danger deleteButton tooltip-left" data-tooltip="{vtranslate('LBL_DELETE', $QUALIFIED_MODULE)}" data-url='{$MODEL->getDeleteUrl()}' type="button" title="{vtranslate('LBL_DELETE', $QUALIFIED_MODULE)}">
            <span>
            <i class="fa fa-remove"></i>
            </span>
            </button>
            </span>
            <span class="btn-group">
            <button class="btn editButton tooltip-left" data-tooltip="{vtranslate('LBL_EDIT', $QUALIFIED_MODULE)}" data-url='{$MODEL->getEditViewUrl()}' type="button" title="{vtranslate('LBL_EDIT', $QUALIFIED_MODULE)}">
            <span>
            <i class="fa fa-pencil"></i>
            </span>
            </button>
            </span>
         </div>
      </div>
   </div>
   <hr>
   <div class="contents row-fluid pull-right">
      <table class="table table-bordered themeTableColor">
         <thead>
            <tr class="blockHeader">
               <th colspan="2">
                  <span class="alignMiddle">{vtranslate('LBL_TWILIO_CREDENTIALS', $QUALIFIED_MODULE)}</span>
               </th>
            </tr>
         </thead>
         <tbody>
            <tr>
               <td class="fieldLabel wide" width="25%"><label class="muted pull-right marginRight10px">{vtranslate('LBL_AUTH_SID', $QUALIFIED_MODULE)}</label></td>
               <td class="fieldValue"><span>{$MODEL->get('sid')}</span></td>
            </tr>
            <tr>
               <td class="fieldLabel wide" width="25%"><label class="muted pull-right marginRight10px">{vtranslate('LBL_AUTH_TOKEN', $QUALIFIED_MODULE)}</label></td>
               <td class="fieldValue"><span>*****oculto*****{*{$MODEL->get('authtoken')}*}</span></td>
            </tr>
         </tbody>
      </table>
      </br>
      <hr>
      <div class="row-fluid">
         {if $MODEL->hasMapping() neq true}
         <div id="noselectorcontainer_desc">
            <div class="well well-lg">{vtranslate('LBL_SELECT_TWILIO_PHONE_NUMBERS_DESCRIPTION', $QUALIFIED_MODULE)}</div>
         </div>
         <div id="noselectorcontainer">
            <table class="table table-bordered themeTableColor">
               <thead>
                  <tr class="blockHeader">
                     <th colspan="2">
                        <span class="alignMiddle">{vtranslate('LBL_SELECT_TWILIO_PHONE_NUMBERS', $QUALIFIED_MODULE)}</span>
                     </th>
                  </tr>
               </thead>
               <tbody>
                  <tr>
                     <td class="fieldLabel wide" width="25%"><label class="muted pull-right marginRight10px">{vtranslate('LBL_SELECT_TWILIO_PHONE_NUMBERS', $QUALIFIED_MODULE)}</label></td>
                     <td class="fieldValue">
                        <select class="chzn-select enablednumbers" multiple>
                           {foreach item=VOICENO from=$MODEL->getVoiceEnabledNumbers()}
                           <option value="{$VOICENO.phone_number}">{$VOICENO.phone_number}</option>
                           {/foreach}
                        </select>
                        <button class="btn btn-success pull-right" id="setupmap"><strong>{vtranslate('LBL_SETUP_PHONE_MAP', $QUALIFIED_MODULE)}</strong></button>
                     </td>
                  </tr>
               </tbody>
            </table>
         </div>
         <form action="index.php">
         <input type="hidden" name="module" value="TwilioCall" />
         <input type="hidden" name="parent" value="Settings" />
         <input type="hidden" name="action" value="SaveMap">
         <div id="mapcontainer" class="hide">
            <div id="rowscontainer">
               <table id="hidemaprow" class="table table-bordered themeTableColor maprow hide" style="margin-top: 10px;">
                  <thead>
                     <tr class="blockHeader">
                        <th>
                           <span class="alignMiddle">{vtranslate('LBL_SELECT_TWILIO_NUMBER', $QUALIFIED_MODULE)}</span>
                        </th>
                        <th>
                           <span class="alignMiddle">{vtranslate('LBL_USER', $QUALIFIED_MODULE)}</span>
                        </th>
                        <th colspan="2">
                           <span class="alignMiddle">{vtranslate('LBL_TWILIO_CLIENT_NAME', $QUALIFIED_MODULE)}</span>
                        </th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td class="fieldValue">
                           <select class="mapvoiceno" style="vertical-align: middle;"></select>
                        </td>
                        <td class="fieldValue">
                           <select class="mapuserid" ></select>
                        </td>
                        <td class="fieldValue">
                           <input type="text" class="mapclient" value="" />
                        </td>
                        <td class="fieldValue">
                           <span><button class="btn btn-danger removerow">{vtranslate('LBL_REMOVE', $QUALIFIED_MODULE)}</button></span>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
            </br>
            <div class="container-fluid" >
               <div class="row-fluid">
                  <div class="pull-right">
                     <span><button id="addblankmap" type="button" class="btn btn-success"><strong>{vtranslate('LBL_ASSIGN_NO_TO_USER', $QUALIFIED_MODULE)}</strong></button></span>
                     &nbsp;<span><button id="savemap" type="button" class="btn btn-success"><strong>{vtranslate('LBL_SAVE_MAP', $QUALIFIED_MODULE)}</strong></button></span>
                     <a href="#" class="cancelLink cancelLinkContainer hide" id="shownoselector">{vtranslate('LBL_BACK', $QUALIFIED_MODULE)}</a>
                  </div>
                  <div class="col-md-2">
                  </div>
               </div>
            </div>
         </div>
         <form>
         {elseif $EDITMAP eq false}
         <div class="pull-right" style="margin-top:1%;margin-bottom:1%;">
            <button class="btn btn-danger edimapbutton" data-url='{$MODEL->getMapEditUrl()}' type="button" title="{vtranslate('LBL_EDIT_MAP', $QUALIFIED_MODULE)}"><strong>{vtranslate('LBL_EDIT_MAP', $QUALIFIED_MODULE)}</strong></button>
         </div>
         <div id="mapviewcontainer" >
            <table class="table table-bordered themeTableColor">
               <thead>
                  <tr>
                     <th>
                        <span>{vtranslate('LBL_SELECT_TWILIO_NUMBER', $QUALIFIED_MODULE)}</span>
                     </th>
                     <th>
                        <span>{vtranslate('LBL_USER', $QUALIFIED_MODULE)}</span>
                     </th>
                     <th>
                        <span>{vtranslate('LBL_TWILIO_CLIENT_NAME', $QUALIFIED_MODULE)}</span>
                     </th>
                  </tr>
               </thead>
               <tbody>
                  {foreach item=MAP from=$MODEL->get('phone_map')}
                  <tr>
                     <td class="fieldValue wide"><span>{$MAP.phone_number}</span></td>
                     <td class="fieldValue wide"><span>{$MODEL->getUsername($MAP.userid)}</span></td>
                     <td class="fieldValue wide"><span>{$MAP.client}</span></td>
                  </tr>
                  {/foreach}
               </tbody>
            </table>
         </div>
         {elseif $EDITMAP eq true}
         <div class="col-sm-8" id="noselectorcontainer_desc">
            <div class="well well-lg">{vtranslate('LBL_SELECT_TWILIO_PHONE_NUMBERS_DESCRIPTION', $QUALIFIED_MODULE)}</div>
         </div>
         <div id="noselectorcontainer">
            <table class="table table-bordered themeTableColor">
               <thead>
                  <tr class="blockHeader">
                     <th colspan="2">
                        <span class="alignMiddle">{vtranslate('LBL_SELECT_TWILIO_PHONE_NUMBERS', $QUALIFIED_MODULE)}</span>
                     </th>
                  </tr>
               </thead>
               <tbody>
                  <tr>
                     <td class="fieldLabel wide" width="25%"><label class="muted pull-right marginRight10px">{vtranslate('LBL_SELECT_TWILIO_PHONE_NUMBERS', $QUALIFIED_MODULE)}</label></td>
                     <td class="fieldValue">
                        <select class="chzn-select enablednumbers" multiple>
                        {foreach item=VOICENO from=$MODEL->getVoiceEnabledNumbers()}
                        <option value="{$VOICENO.phone_number}" {if $VOICENO.active eq 1}selected{/if}>{$VOICENO.phone_number}</option>
                        {/foreach}
                        </select>
                        <button class="btn btn-success pull-right" id="setupmap"><strong>{vtranslate('LBL_SETUP_PHONE_MAP', $QUALIFIED_MODULE)}</strong></button>
                     </td>
                  </tr>
               </tbody>
            </table>
         </div>
         <form action="index.php">
         <input type="hidden" name="module" value="TwilioCall" />
         <input type="hidden" name="parent" value="Settings" />
         <input type="hidden" name="action" value="SaveMap" />
         <input type="hidden" id="editmap" name="editmap" value="true" />
         <div id="mapcontainer" class="hide">
            <div class="container-fluid" id="rowscontainer">
               <table id="hidemaprow" class="table table-bordered themeTableColor maprow hide" style="margin-top: 10px;">
                  <thead>
                     <tr class="blockHeader">
                        <th>
                           <span class="alignMiddle">{vtranslate('LBL_SELECT_TWILIO_NUMBER', $QUALIFIED_MODULE)}</span>
                        </th>
                        <th>
                           <span class="alignMiddle">{vtranslate('LBL_USER', $QUALIFIED_MODULE)}</span>
                        </th>
                        <th colspan="2">
                           <span class="alignMiddle">{vtranslate('LBL_TWILIO_CLIENT_NAME', $QUALIFIED_MODULE)}</span>
                        </th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr class>
                        <td class="fieldValue">
                           <select class="mapvoiceno" style="vertical-align: middle;"></select>
                        </td>
                        <td class="fieldValue">
                           <select class="mapuserid" ></select>
                        </td>
                        <td class="fieldValue">
                           <input type="text" class="mapclient" value="" />
                        </td>
                        <td class="fieldValue">
                           <span><button class="btn btn-danger removerow">{vtranslate('LBL_REMOVE', $QUALIFIED_MODULE)}</button></span>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
            </br>
            <div class="container-fluid" >
               <div class="row-fluid">
                  <div class="pull-right">
                     <span><button id="addblankmap" type="button" class="btn btn-success"><strong>{vtranslate('LBL_ASSIGN_NO_TO_USER', $QUALIFIED_MODULE)}</strong></button></span>
                     &nbsp;<span><button id="savemap" type="button" class="btn btn-success"><strong>{vtranslate('LBL_SAVE_MAP', $QUALIFIED_MODULE)}</strong></button></span>
                  </div>
                  <div class="col-md-2">
                  </div>
               </div>
            </div>
         </div>
         <form>
         {/if}
      </div>
   </div>
</div>
{/strip}